/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.slingstart.BuildConstants;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;

public class JarArchiverHelper {
    private final JarArchiver archiver;
    private final MavenProject project;

    public JarArchiverHelper(JarArchiver archiver, MavenProject project, File destFile) throws MojoExecutionException {
        this(archiver, project, destFile, null);
    }

    public JarArchiverHelper(JarArchiver archiver, MavenProject project, File destFile, Manifest manifest) throws MojoExecutionException {
        this.project = project;
        this.archiver = archiver;
        this.archiver.reset();
        this.archiver.setDestFile(destFile);
        this.createManifest(manifest);
    }

    private void createManifest(Manifest manifest) throws MojoExecutionException {
        org.codehaus.plexus.archiver.jar.Manifest outManifest = new org.codehaus.plexus.archiver.jar.Manifest();
        try {
            String organizationName;
            boolean hasMain = false;
            if (manifest != null) {
                Attributes attrs = manifest.getMainAttributes();
                for (Map.Entry entry : attrs.entrySet()) {
                    String key = entry.getKey().toString();
                    if (!BuildConstants.ATTRS_EXCLUDES.contains(key)) {
                        Manifest.Attribute a = new Manifest.Attribute(key, entry.getValue().toString());
                        outManifest.addConfiguredAttribute(a);
                    }
                    if (!key.equals("Main-Class")) continue;
                    hasMain = true;
                }
            }
            outManifest.addConfiguredAttribute(new Manifest.Attribute("Implementation-Build", this.project.getVersion()));
            outManifest.addConfiguredAttribute(new Manifest.Attribute("Implementation-Version", this.project.getVersion()));
            String string = organizationName = this.project.getOrganization() != null ? this.project.getOrganization().getName() : null;
            if (organizationName != null) {
                outManifest.addConfiguredAttribute(new Manifest.Attribute("Implementation-Vendor", organizationName));
                outManifest.addConfiguredAttribute(new Manifest.Attribute("Created-By", organizationName));
                outManifest.addConfiguredAttribute(new Manifest.Attribute("Built-By", organizationName));
                outManifest.addConfiguredAttribute(new Manifest.Attribute("Specification-Vendor", organizationName));
            }
            outManifest.addConfiguredAttribute(new Manifest.Attribute("Implementation-Vendor-Id", this.project.getGroupId()));
            outManifest.addConfiguredAttribute(new Manifest.Attribute("Implementation-Title", this.project.getName()));
            outManifest.addConfiguredAttribute(new Manifest.Attribute("Specification-Title", this.project.getName()));
            outManifest.addConfiguredAttribute(new Manifest.Attribute("Specification-Version", this.project.getVersion()));
            if (this.archiver.getDestFile().getName().endsWith(".jar") && !hasMain) {
                outManifest.addConfiguredAttribute(new Manifest.Attribute("Main-Class", "org.apache.sling.launchpad.app.Main"));
            }
            this.archiver.addConfiguredManifest(outManifest);
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("Unable to create manifest for " + this.archiver.getDestFile(), (Exception)((Object)e));
        }
    }

    public void addDirectory(File directory, String prefix, String[] includes, String[] excludes) throws MojoExecutionException {
        try {
            this.archiver.addDirectory(directory, prefix, includes, excludes);
        }
        catch (ArchiverException ae) {
            throw new MojoExecutionException("Unable to create archive for " + this.archiver.getDestFile(), (Exception)((Object)ae));
        }
    }

    public void addDirectory(File directory, String prefix) throws MojoExecutionException {
        try {
            this.archiver.addDirectory(directory, prefix);
        }
        catch (ArchiverException ae) {
            throw new MojoExecutionException("Unable to create archive for " + this.archiver.getDestFile(), (Exception)((Object)ae));
        }
    }

    public void addDirectory(File directory, String[] includes, String[] excludes) throws MojoExecutionException {
        try {
            this.archiver.addDirectory(directory, includes, excludes);
        }
        catch (ArchiverException ae) {
            throw new MojoExecutionException("Unable to create archive for " + this.archiver.getDestFile(), (Exception)((Object)ae));
        }
    }

    public void addDirectory(File directory) throws MojoExecutionException {
        try {
            this.archiver.addDirectory(directory);
        }
        catch (ArchiverException ae) {
            throw new MojoExecutionException("Unable to create archive for " + this.archiver.getDestFile(), (Exception)((Object)ae));
        }
    }

    public void addFile(File arg0, String arg1, int arg2) throws MojoExecutionException {
        try {
            this.archiver.addFile(arg0, arg1, arg2);
        }
        catch (ArchiverException ae) {
            throw new MojoExecutionException("Unable to create archive for " + this.archiver.getDestFile(), (Exception)((Object)ae));
        }
    }

    public void addFile(File inputFile, String destFileName) throws MojoExecutionException {
        try {
            this.archiver.addFile(inputFile, destFileName);
        }
        catch (ArchiverException ae) {
            throw new MojoExecutionException("Unable to create archive for " + this.archiver.getDestFile(), (Exception)((Object)ae));
        }
    }

    public void createArchive() throws MojoExecutionException {
        try {
            this.archiver.createArchive();
        }
        catch (ArchiverException ae) {
            throw new MojoExecutionException("Unable to create archive for " + this.archiver.getDestFile(), (Exception)((Object)ae));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create archive for " + this.archiver.getDestFile(), (Exception)e);
        }
    }

    public void addArtifacts(Map<String, File> globalContentsMap, String prefix) throws MojoExecutionException {
        for (Map.Entry<String, File> entry : globalContentsMap.entrySet()) {
            if (entry.getValue().isFile()) {
                this.addFile(entry.getValue(), prefix + entry.getKey());
                continue;
            }
            this.addDirectory(entry.getValue(), prefix);
        }
    }
}

