/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.kickstart.launcher;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;

public class Main {
    private final String[] startupArgs;
    private final boolean verbose;
    private final File appJar;
    private final int listenerPort;
    private static final String MAIN_CLASS_DEF = "org.apache.sling.kickstart.app.KickstartStarter";
    private static final String DELIM = "-------------------------------------------------------------------";

    public Main(String[] args) {
        if (args == null || args.length < 3) {
            throw new IllegalArgumentException("Missing configuration: " + args);
        }
        this.appJar = new File(args[0]);
        this.listenerPort = Integer.valueOf(args[1]);
        this.verbose = Boolean.valueOf(args[2]);
        if (this.verbose) {
            System.out.println("App Jar: " + this.appJar);
            System.out.println("Listener Port: " + this.listenerPort);
            System.out.println("Verbose: " + this.verbose);
        }
        this.startupArgs = new String[args.length - 3];
        System.arraycopy(args, 3, this.startupArgs, 0, this.startupArgs.length);
    }

    public void run() throws Exception {
        if (this.verbose) {
            System.out.println(DELIM);
            System.out.println("Kickstart application: " + this.appJar);
            System.out.println("Main class: org.apache.sling.kickstart.app.KickstartStarter");
            System.out.println("Listener Port: " + String.valueOf(this.listenerPort));
            System.out.println("Arguments: " + Arrays.toString(this.startupArgs));
            System.out.println(DELIM);
        }
        URLClassLoader cl = new URLClassLoader(new URL[]{this.appJar.toURI().toURL()});
        Thread.currentThread().setContextClassLoader(cl);
        Class<?> mainClass = cl.loadClass(MAIN_CLASS_DEF);
        Method mainMethod = mainClass.getDeclaredMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{this.startupArgs});
    }

    public static void main(String[] args) {
        try {
            Main m = new Main(args);
            m.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

