/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.autosave;

import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.oak.security.user.autosave.AuthorizableImpl;
import org.apache.jackrabbit.oak.security.user.autosave.AuthorizableWrapper;
import org.apache.jackrabbit.oak.security.user.autosave.AutoSaveEnabledManager;
import org.jetbrains.annotations.NotNull;

class GroupImpl
extends AuthorizableImpl
implements Group {
    GroupImpl(Group dlg, AutoSaveEnabledManager mgr) {
        super(dlg, mgr);
    }

    private Group getDelegate() {
        return (Group)this.getDlg();
    }

    @Override
    @NotNull
    public Iterator<Authorizable> getDeclaredMembers() throws RepositoryException {
        return AuthorizableWrapper.createIterator(this.getDelegate().getDeclaredMembers(), this.getMgr());
    }

    @Override
    @NotNull
    public Iterator<Authorizable> getMembers() throws RepositoryException {
        return AuthorizableWrapper.createIterator(this.getDelegate().getMembers(), this.getMgr());
    }

    @Override
    public boolean isDeclaredMember(@NotNull Authorizable authorizable) throws RepositoryException {
        if (GroupImpl.isValid(authorizable)) {
            return this.getDelegate().isDeclaredMember(((AuthorizableImpl)authorizable).getDlg());
        }
        return false;
    }

    @Override
    public boolean isMember(@NotNull Authorizable authorizable) throws RepositoryException {
        if (GroupImpl.isValid(authorizable)) {
            return this.getDelegate().isMember(((AuthorizableImpl)authorizable).getDlg());
        }
        return false;
    }

    @Override
    public boolean addMember(@NotNull Authorizable authorizable) throws RepositoryException {
        try {
            if (GroupImpl.isValid(authorizable)) {
                boolean bl = this.getDelegate().addMember(((AuthorizableImpl)authorizable).getDlg());
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.getMgr().autosave();
        }
    }

    @Override
    @NotNull
    public Set<String> addMembers(String ... memberIds) throws RepositoryException {
        try {
            Set<String> set = this.getDelegate().addMembers(memberIds);
            return set;
        }
        finally {
            this.getMgr().autosave();
        }
    }

    @Override
    public boolean removeMember(@NotNull Authorizable authorizable) throws RepositoryException {
        try {
            if (GroupImpl.isValid(authorizable)) {
                boolean bl = this.getDelegate().removeMember(((AuthorizableImpl)authorizable).getDlg());
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.getMgr().autosave();
        }
    }

    @Override
    @NotNull
    public Set<String> removeMembers(String ... memberIds) throws RepositoryException {
        try {
            Set<String> set = this.getDelegate().removeMembers(memberIds);
            return set;
        }
        finally {
            this.getMgr().autosave();
        }
    }

    private static boolean isValid(@NotNull Authorizable a) {
        return a instanceof AuthorizableImpl;
    }
}

