/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitRateLimiter
implements CommitHook {
    private static final Logger LOG = LoggerFactory.getLogger(CommitRateLimiter.class);
    private volatile boolean blockCommits;
    private volatile long delay;
    private static ThreadLocal<AtomicInteger> NON_BLOCKING_LEVEL = new ThreadLocal();
    private static boolean EXCEPTION_ON_BLOCK = Boolean.getBoolean("oak.commitRateLimiter.exceptionOnBlock");

    public void blockCommits() {
        this.blockCommits = true;
    }

    public void unblockCommits() {
        this.blockCommits = false;
    }

    public boolean getBlockCommits() {
        return this.blockCommits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelay(long delay) {
        if (LOG.isTraceEnabled() && this.delay != delay) {
            LOG.trace("setDelay: delay changed from " + this.delay + " to " + delay);
        }
        this.delay = delay;
        if (delay == 0L) {
            CommitRateLimiter commitRateLimiter = this;
            synchronized (commitRateLimiter) {
                this.notifyAll();
            }
        }
    }

    @Override
    @NotNull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
        if (this.blockCommits && this.isThreadBlocking()) {
            this.blockCommit();
        } else {
            this.delay();
        }
        return after;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockCommit() throws CommitFailedException {
        if (EXCEPTION_ON_BLOCK) {
            throw new CommitFailedException("Oak", 1, "System busy. Try again later.");
        }
        CommitRateLimiter commitRateLimiter = this;
        synchronized (commitRateLimiter) {
            try {
                while (this.getBlockCommits()) {
                    this.wait(1000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CommitFailedException("Oak", 2, "Interrupted while waiting to commit", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delay() throws CommitFailedException {
        if (this.delay > 0L && this.isThreadBlocking()) {
            CommitRateLimiter commitRateLimiter = this;
            synchronized (commitRateLimiter) {
                try {
                    long t0 = Clock.ACCURATE.getTime();
                    long dt = this.delay;
                    while (this.delay > 0L && dt > 0L) {
                        LOG.trace("delay: waiting {}ms (delay={}ms)", (Object)dt, (Object)this.delay);
                        this.wait(dt);
                        dt = dt - Clock.ACCURATE.getTime() + t0;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new CommitFailedException("Oak", 2, "Interrupted while waiting to commit", e);
                }
            }
        }
    }

    public void beforeNonBlocking() {
        AtomicInteger value = NON_BLOCKING_LEVEL.get();
        if (value == null) {
            value = new AtomicInteger(1);
            NON_BLOCKING_LEVEL.set(value);
        } else {
            value.incrementAndGet();
        }
    }

    public void afterNonBlocking() {
        AtomicInteger value = NON_BLOCKING_LEVEL.get();
        if (value != null) {
            value.decrementAndGet();
        }
    }

    public boolean isThreadBlocking() {
        AtomicInteger value = NON_BLOCKING_LEVEL.get();
        return value == null || value.get() == 0;
    }
}

