/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.name;

import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.name.ReadOnlyNamespaceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReadWriteNamespaceRegistry
extends ReadOnlyNamespaceRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ReadWriteNamespaceRegistry.class);

    public ReadWriteNamespaceRegistry(Root root) {
        super(root);
    }

    protected abstract Root getWriteRoot();

    protected void refresh() throws RepositoryException {
    }

    @Override
    public void registerNamespace(String prefix, String uri) throws RepositoryException {
        if (!"internal".equals(uri) && !uri.contains(":")) {
            LOG.error("Registering invalid namespace name '" + uri + "' for prefix '" + prefix + "', please see https://developer.adobe.com/experience-manager/reference-materials/spec/jcr/2.0/3_Repository_Model.html#3.2.1%20Namespaces", (Throwable)new Exception("call stack"));
        }
        if (prefix.isEmpty() && uri.isEmpty()) {
            return;
        }
        if (prefix.isEmpty() || uri.isEmpty()) {
            throw new NamespaceException("Cannot remap the default empty namespace");
        }
        PropertyState property = this.namespaces.getProperty(prefix);
        if (property != null && property.getType() == Type.STRING && uri.equals(property.getValue(Type.STRING))) {
            return;
        }
        try {
            Root root = this.getWriteRoot();
            Tree namespaces = root.getTree("/jcr:system/rep:namespaces");
            for (PropertyState propertyState : namespaces.getProperties()) {
                if (propertyState.getType() != Type.STRING || !uri.equals(propertyState.getValue(Type.STRING))) continue;
                namespaces.removeProperty(propertyState.getName());
            }
            namespaces.setProperty(prefix, uri);
            root.commit();
            this.refresh();
        }
        catch (CommitFailedException e) {
            throw e.asRepositoryException("Failed to register namespace mapping " + prefix + " -> " + uri);
        }
    }

    @Override
    public void unregisterNamespace(String prefix) throws RepositoryException {
        if (prefix.isEmpty()) {
            throw new NamespaceException("Cannot unregister the default empty namespace");
        }
        Root root = this.getWriteRoot();
        Tree namespaces = root.getTree("/jcr:system/rep:namespaces");
        if (!namespaces.exists() || !namespaces.hasProperty(prefix)) {
            throw new NamespaceException("Namespace mapping from " + prefix + " to " + this.getURI(prefix) + " can not be unregistered");
        }
        try {
            namespaces.removeProperty(prefix);
            root.commit();
            this.refresh();
        }
        catch (CommitFailedException e) {
            String message = "Failed to unregister namespace mapping for prefix " + prefix;
            throw e.asRepositoryException(message);
        }
    }
}

