/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.HashSet;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionWriteOperation;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.nodetype.PropertyDefinitionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AddMixinOperation
implements SessionWriteOperation<Object> {
    private final NodeImpl node;
    private final Name mixinName;

    public AddMixinOperation(NodeImpl node, Name mixinName) {
        this.node = node;
        this.mixinName = mixinName;
    }

    @Override
    public Object perform(SessionContext context) throws RepositoryException {
        EffectiveNodeType entExisting;
        int permissions = 128;
        if (NameConstants.MIX_VERSIONABLE.equals(this.mixinName) || NameConstants.MIX_SIMPLE_VERSIONABLE.equals(this.mixinName)) {
            permissions |= 0x100;
        }
        context.getItemValidator().checkModify(this.node, 150, permissions);
        NodeTypeManagerImpl ntMgr = context.getNodeTypeManager();
        NodeTypeImpl mixin = ntMgr.getNodeType(this.mixinName);
        if (!mixin.isMixin()) {
            throw new RepositoryException(context.getJCRName(this.mixinName) + " is not a mixin node type");
        }
        Name primaryTypeName = this.node.getNodeState().getNodeTypeName();
        NodeTypeImpl primaryType = ntMgr.getNodeType(primaryTypeName);
        if (primaryType.isDerivedFrom(this.mixinName)) {
            return this;
        }
        NodeTypeRegistry ntReg = context.getNodeTypeRegistry();
        try {
            HashSet<Name> mixins = new HashSet<Name>(this.node.getNodeState().getMixinTypeNames());
            entExisting = ntReg.getEffectiveNodeType(primaryTypeName, mixins);
            if (entExisting.includesNodeType(this.mixinName)) {
                return this;
            }
            mixins.add(this.mixinName);
            ntReg.getEffectiveNodeType(primaryTypeName, mixins);
        }
        catch (NodeTypeConflictException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        try {
            NodeTypeImpl declaringNT;
            NodeState thisState = (NodeState)this.node.getOrCreateTransientItemState();
            HashSet<Name> mixins = new HashSet<Name>(thisState.getMixinTypeNames());
            mixins.add(this.mixinName);
            thisState.setMixinTypeNames(mixins);
            this.node.setMixinTypesProperty(mixins);
            for (PropertyDefinition propertyDefinition : mixin.getAutoCreatedPropertyDefinitions()) {
                PropertyDefinitionImpl pd = (PropertyDefinitionImpl)propertyDefinition;
                declaringNT = (NodeTypeImpl)pd.getDeclaringNodeType();
                if (entExisting.includesNodeType(declaringNT.getQName())) continue;
                this.node.createChildProperty(pd.unwrap().getName(), pd.getRequiredType(), pd);
            }
            for (PropertyDefinition propertyDefinition : mixin.getAutoCreatedNodeDefinitions()) {
                NodeDefinitionImpl nd = (NodeDefinitionImpl)propertyDefinition;
                declaringNT = (NodeTypeImpl)nd.getDeclaringNodeType();
                if (entExisting.includesNodeType(declaringNT.getQName())) continue;
                this.node.createChildNode(nd.unwrap().getName(), (NodeTypeImpl)nd.getDefaultPrimaryType(), null);
            }
        }
        catch (RepositoryException re) {
            try {
                this.node.removeMixin(this.mixinName);
            }
            catch (RepositoryException re1) {
                // empty catch block
            }
            throw re;
        }
        return this;
    }

    public String toString() {
        return "node.addMixin(" + this.mixinName + ")";
    }
}

