/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.serversetup.instance;

import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.serversetup.instance.SlingInstance;
import org.apache.sling.testing.serversetup.instance.SlingInstanceManager;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SlingInstancesRule
implements TestRule {
    private SlingInstance currentInstance;
    private final Iterable<SlingInstance> instances;

    public SlingInstancesRule(String ... instanceNames) throws ClientException {
        this(new SlingInstanceManager(instanceNames));
    }

    public SlingInstancesRule(Iterable<SlingInstance> it) {
        this.instances = it;
    }

    public Statement apply(final Statement base, Description dest) {
        return new Statement(){

            public void evaluate() throws Throwable {
                for (SlingInstance instance : SlingInstancesRule.this.instances) {
                    SlingInstancesRule.this.currentInstance = instance;
                    base.evaluate();
                }
                SlingInstancesRule.this.currentInstance = null;
            }
        };
    }

    public SlingInstance getSlingInstance() {
        return this.currentInstance;
    }
}

