/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.junit.rules.instance;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.instance.InstanceConfiguration;
import org.apache.sling.testing.junit.rules.instance.BuilderCustomizer;
import org.apache.sling.testing.junit.rules.instance.Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInstance
implements Instance {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInstance.class);
    private final Map<String, SlingClient> clientsCache = new ConcurrentHashMap<String, SlingClient>(1);

    @Override
    public <T extends SlingClient.InternalBuilder> T customize(T builder) {
        return builder;
    }

    @Override
    public <T extends SlingClient> T newClient(Class<T> clientClass, String user, String pass, BuilderCustomizer ... customizers) {
        InstanceConfiguration configuration = this.getConfiguration();
        try {
            Object builder = this.getBuilder(clientClass, configuration.getUrl(), user, pass);
            for (BuilderCustomizer customizer : customizers) {
                builder = customizer.customize(builder);
            }
            SlingClient client = (SlingClient)builder.build().adaptTo(clientClass);
            this.clientsCache.put(user + pass, client);
            return (T)client;
        }
        catch (ClientException e) {
            return null;
        }
    }

    private Class getBuilderClass(Class clientClass) {
        if (!SlingClient.class.isAssignableFrom(clientClass)) {
            return null;
        }
        if (clientClass == SlingClient.class) {
            return SlingClient.Builder.class;
        }
        for (Class<?> clazz : clientClass.getDeclaredClasses()) {
            if (!SlingClient.InternalBuilder.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) continue;
            return clazz;
        }
        if (null == clientClass.getSuperclass()) {
            return null;
        }
        return this.getBuilderClass(clientClass.getSuperclass());
    }

    protected <B extends SlingClient.InternalBuilder, T extends SlingClient> B getBuilder(Class<T> clientClass, URI url, String user, String password) {
        SlingClient.InternalBuilder builder;
        Class builderClass = this.getBuilderClass(clientClass);
        try {
            Method create = builderClass.getMethod("create", URI.class, String.class, String.class);
            builder = (SlingClient.InternalBuilder)create.invoke(null, url, user, password);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        return (B)this.customize(builder);
    }

    @Override
    public SlingClient newAdminClient(BuilderCustomizer ... customizers) {
        return this.newClient(SlingClient.class, this.getConfiguration().getAdminUser(), this.getConfiguration().getAdminPassword(), customizers);
    }

    @Override
    public <T extends SlingClient> T getClient(Class<T> clientClass, String user, String pass) {
        if (this.clientsCache.containsKey(user + pass)) {
            try {
                return (T)((SlingClient)this.clientsCache.get(user + pass).adaptTo(clientClass));
            }
            catch (ClientException e) {
                return null;
            }
        }
        return this.newClient(clientClass, user, pass, new BuilderCustomizer[0]);
    }

    @Override
    public SlingClient getAdminClient() {
        return this.getAdminClient(SlingClient.class);
    }

    @Override
    public <T extends SlingClient> T getAdminClient(Class<T> clientClass) {
        return this.getClient(clientClass, this.getConfiguration().getAdminUser(), this.getConfiguration().getAdminPassword());
    }
}

