/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.script.Bindings;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.extension.ExtensionUtils;
import org.apache.sling.scripting.sightly.impl.engine.extension.PrintWriterJakartaResponseWrapper;
import org.apache.sling.scripting.sightly.impl.engine.extension.PrintWriterResponseWrapper;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RuntimeExtension.class}, property={"org.apache.sling.scripting.sightly.extension.name=include"})
public class IncludeRuntimeExtension
implements RuntimeExtension {
    private static final Logger LOG = LoggerFactory.getLogger(IncludeRuntimeExtension.class);
    private static final String OPTION_FILE = "file";
    private static final String OPTION_PREPEND_PATH = "prependPath";
    private static final String OPTION_APPEND_PATH = "appendPath";
    private static final String OPTION_REQUEST_ATTRIBUTES = "requestAttributes";

    public Object call(RenderContext renderContext, Object ... arguments) {
        ExtensionUtils.checkArgumentCount("include", arguments, 2);
        RuntimeObjectModel runtimeObjectModel = renderContext.getObjectModel();
        String originalPath = runtimeObjectModel.toString(arguments[0]);
        Map options = (Map)arguments[1];
        String path = this.buildPath(originalPath, options);
        StringWriter output = new StringWriter();
        Bindings bindings = renderContext.getBindings();
        SlingJakartaHttpServletRequest request = BindingsUtils.getJakartaRequest(bindings);
        Map<String, Object> originalAttributes = ExtensionUtils.setRequestAttributes(request, (Map)options.remove(OPTION_REQUEST_ATTRIBUTES));
        this.includeScript(bindings, path, new PrintWriter(output));
        ExtensionUtils.setRequestAttributes(request, originalAttributes);
        return output.toString();
    }

    private String buildPath(String path, Map<?, ?> options) {
        Object appendPath;
        if (StringUtils.isEmpty((CharSequence)path)) {
            path = (String)options.get(OPTION_FILE);
        }
        if (StringUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        Object prependPath = (String)options.get(OPTION_PREPEND_PATH);
        if (prependPath == null) {
            prependPath = "";
        }
        if (StringUtils.isNotEmpty((CharSequence)prependPath) && !((String)prependPath).endsWith("/") && !path.startsWith("/")) {
            prependPath = (String)prependPath + "/";
        }
        if ((appendPath = (String)options.get(OPTION_APPEND_PATH)) == null) {
            appendPath = "";
        }
        if (StringUtils.isNotEmpty((CharSequence)appendPath) && !((String)appendPath).startsWith("/") && !path.endsWith("/")) {
            appendPath = "/" + (String)appendPath;
        }
        return (String)prependPath + path + (String)appendPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void includeScript(Bindings bindings, String script, PrintWriter out) {
        if (StringUtils.isEmpty((CharSequence)script)) {
            throw new SightlyException("Path for data-sly-include is empty");
        }
        LOG.debug("Attempting to include script {}.", (Object)script);
        SlingScriptHelper slingScriptHelper = BindingsUtils.getHelper(bindings);
        ServletResolver servletResolver = (ServletResolver)slingScriptHelper.getService(ServletResolver.class);
        if (servletResolver == null) throw new SightlyException("Sling ServletResolver service is unavailable, failed to include " + script);
        SlingJakartaHttpServletRequest jakartaRequest = BindingsUtils.getJakartaRequest(bindings);
        jakarta.servlet.Servlet jakartaServlet = servletResolver.resolve(jakartaRequest.getResource(), script);
        if (jakartaServlet != null) {
            try {
                SlingJakartaHttpServletResponse response = BindingsUtils.getJakartaResponse(bindings);
                PrintWriterJakartaResponseWrapper resWrapper = new PrintWriterJakartaResponseWrapper(out, response);
                jakartaServlet.service((jakarta.servlet.ServletRequest)jakartaRequest, (jakarta.servlet.ServletResponse)resWrapper);
                return;
            }
            catch (Exception e) {
                throw new SightlyException("Failed to include script " + script, (Throwable)e);
            }
        }
        SlingHttpServletRequest javaxRequest = BindingsUtils.getRequest(bindings);
        Servlet javaxServlet = servletResolver.resolveServlet(javaxRequest.getResource(), script);
        if (javaxServlet == null) throw new SightlyException("Failed to locate script " + script);
        try {
            SlingHttpServletResponse response = BindingsUtils.getResponse(bindings);
            PrintWriterResponseWrapper resWrapper = new PrintWriterResponseWrapper(out, response);
            javaxServlet.service((ServletRequest)javaxRequest, (ServletResponse)resWrapper);
            return;
        }
        catch (Exception e) {
            throw new SightlyException("Failed to include script " + script, (Throwable)e);
        }
    }
}

