/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.wrapper;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.sling.scripting.javascript.SlingWrapper;
import org.apache.sling.scripting.javascript.wrapper.ScriptableBase;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class ScriptableCalendar
extends ScriptableBase
implements SlingWrapper {
    public static final String CLASSNAME = "Calendar";
    private SimpleDateFormat calendarFormat;
    static final String ECMA_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z";
    static final Locale DATE_FORMAT_LOCALE = Locale.US;
    private static final Class<?>[] WRAPPED_CLASSES = new Class[]{Calendar.class, GregorianCalendar.class};
    private Calendar calendar;

    @Override
    public Class<?>[] getWrappedClasses() {
        return WRAPPED_CLASSES;
    }

    public void jsConstructor(Object o) {
        this.calendar = (Calendar)o;
    }

    public Object get(String name, Scriptable start) {
        Object fromSuperclass = super.get(name, start);
        if (fromSuperclass != Scriptable.NOT_FOUND) {
            return fromSuperclass;
        }
        if (this.calendar == null) {
            return Undefined.instance;
        }
        if ("date".equals(name)) {
            return ScriptRuntime.toObject((Scriptable)this, (Object)this.calendar.getTime());
        }
        return this.getNative(name, start);
    }

    @Override
    protected Class<?> getStaticType() {
        return Calendar.class;
    }

    @Override
    protected Object getWrappedObject() {
        return this.calendar;
    }

    @Override
    public String getClassName() {
        return CLASSNAME;
    }

    public String toString() {
        if (this.calendarFormat == null) {
            this.calendarFormat = new SimpleDateFormat(ECMA_DATE_FORMAT, DATE_FORMAT_LOCALE);
        }
        return this.calendarFormat.format(this.calendar.getTime());
    }

    public Object unwrap() {
        return this.calendar;
    }

    public Object getDefaultValue(Class typeHint) {
        return this.toString();
    }
}

