/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.impl.iterator.tree;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.sling.query.api.internal.TreeProvider;
import org.apache.sling.query.impl.iterator.AbstractIterator;

public class DfsTreeIterator<T>
extends AbstractIterator<T> {
    private final Deque<Iterator<T>> queue = new LinkedList<Iterator<T>>();
    private final TreeProvider<T> provider;

    public DfsTreeIterator(T root, TreeProvider<T> provider) {
        this.provider = provider;
        this.queue.add(provider.listChildren(root));
    }

    @Override
    protected T getElement() {
        if (this.queue.isEmpty()) {
            return null;
        }
        if (this.queue.peekLast().hasNext()) {
            T next = this.queue.peekLast().next();
            this.queue.add(this.provider.listChildren(next));
            return next;
        }
        this.queue.pollLast();
        return this.getElement();
    }
}

