/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.performance;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.NamingException;
import org.apache.sling.commons.testing.jcr.RepositoryUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.performance.IdentifiableTestClass;

public abstract class AbstractRepositoryTest
implements IdentifiableTestClass {
    protected String testInstanceName;
    private static SlingRepository repository;
    private int counter;
    protected Session session;
    protected Node testRoot;

    public AbstractRepositoryTest(String testInstanceName) {
        this.testInstanceName = testInstanceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SlingRepository getRepository() throws RepositoryException, NamingException {
        if (repository != null) {
            return repository;
        }
        Class<AbstractRepositoryTest> clazz = AbstractRepositoryTest.class;
        synchronized (AbstractRepositoryTest.class) {
            if (repository == null) {
                RepositoryUtil.startRepository();
                repository = RepositoryUtil.getRepository();
                Runtime.getRuntime().addShutdownHook(new ShutdownThread());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return repository;
        }
    }

    protected Session getSession() throws RepositoryException, NamingException {
        if (this.session == null) {
            this.session = this.getRepository().loginAdministrative(null);
        }
        return this.session;
    }

    protected Node getTestRootNode() throws RepositoryException, NamingException {
        if (this.testRoot == null) {
            Node root = this.getSession().getRootNode();
            Node classRoot = root.addNode(this.getClass().getSimpleName());
            this.testRoot = classRoot.addNode(System.currentTimeMillis() + "_" + ++this.counter);
        }
        return this.testRoot;
    }

    public String testClassName() {
        return this.testInstanceName;
    }

    private static class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        public void run() {
            try {
                RepositoryUtil.stopRepository();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

