/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.couchbase.client;

import aQute.bnd.annotation.ProviderType;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;

@ProviderType
public final class CouchbaseKey {
    static final int MAX_KEY_LENGTH = 250;

    private CouchbaseKey() {
    }

    public static String build(String key, String keyPrefix) {
        String cacheKey = keyPrefix + key;
        if (cacheKey.length() < 250) {
            return cacheKey;
        }
        int charactersToKeep = 250 - keyPrefix.length() - 41;
        String toKeep = key.substring(0, charactersToKeep);
        String toHash = key.substring(charactersToKeep);
        String hash = CouchbaseKey.calculateHash(toHash);
        return keyPrefix + toKeep + "#" + hash;
    }

    private static String calculateHash(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(message.getBytes("UTF-8"));
            byte[] digestBytes = digest.digest();
            return DatatypeConverter.printHexBinary((byte[])digestBytes).toLowerCase();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Failed to create sha1 Hash from " + message, ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Failed to create sha1 Hash from " + message, ex);
        }
    }
}

