/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webdav.impl.servlets;

import java.io.IOException;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.jackrabbit.server.SessionProvider;
import org.apache.jackrabbit.server.io.CopyMoveHandler;
import org.apache.jackrabbit.server.io.DeleteHandler;
import org.apache.jackrabbit.server.io.IOHandler;
import org.apache.jackrabbit.server.io.PropertyHandler;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.simple.SimpleWebdavServlet;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.webdav.impl.handler.SlingCopyMoveManager;
import org.apache.sling.jcr.webdav.impl.handler.SlingDeleteManager;
import org.apache.sling.jcr.webdav.impl.handler.SlingIOManager;
import org.apache.sling.jcr.webdav.impl.handler.SlingPropertyManager;
import org.apache.sling.jcr.webdav.impl.helper.SlingLocatorFactory;
import org.apache.sling.jcr.webdav.impl.helper.SlingResourceConfig;
import org.apache.sling.jcr.webdav.impl.helper.SlingSessionProvider;
import org.apache.sling.jcr.webdav.impl.servlets.SlingSimpleWebDavServlet;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(name="org.apache.sling.jcr.webdav.impl.servlets.SimpleWebDavServlet", configurationPolicy=ConfigurationPolicy.REQUIRE, service={Servlet.class}, property={"sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=*"}, reference={@Reference(name="IOHandler", service=IOHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindIOHandler", unbind="unbindIOHandler"), @Reference(name="PropertyHandler", service=PropertyHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindPropertyHandler", unbind="unbindPropertyHandler"), @Reference(name="CopyMoveHandler", service=CopyMoveHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindCopyMoveHandler", unbind="unbindCopyMoveHandler"), @Reference(name="DeleteHandler", service=DeleteHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindDeleteHandler", unbind="unbindDeleteHandler")})
@ServiceDescription(value="Sling WebDAV Servlet")
@ServiceVendor(value="The Apache Software Foundation")
@Designate(ocd=Config.class)
public class SlingWebDavServlet
extends SimpleWebdavServlet {
    public static final String DEFAULT_CONTEXT = "/dav";
    public static final boolean DEFAULT_CREATE_ABSOLUTE_URI = true;
    public static final String DEFAULT_REALM = "Sling WebDAV";
    public static final String TYPE_NONCOLLECTIONS_DEFAULT = "nt:file";
    public static final String TYPE_CONTENT_DEFAULT = "nt:resource";
    public static final String TYPE_COLLECTIONS_DEFAULT = "sling:Folder";
    public static final String TYPE_COLLECTIONS = "type.collections";
    public static final String TYPE_NONCOLLECTIONS = "type.noncollections";
    public static final String TYPE_CONTENT = "type.content";
    static final String IOHANDLER_REF_NAME = "IOHandler";
    static final String PROPERTYHANDLER_REF_NAME = "PropertyHandler";
    static final String COPYMOVEHANDLER_REF_NAME = "CopyMoveHandler";
    static final String DELETEHANDLER_REF_NAME = "DeleteHandler";
    @Reference
    private SlingRepository repository;
    @Reference
    private HttpService httpService;
    @Reference
    private MimeTypeService mimeTypeService;
    private final SlingIOManager ioManager = new SlingIOManager("IOHandler");
    private final SlingPropertyManager propertyManager = new SlingPropertyManager("PropertyHandler");
    private final SlingCopyMoveManager copyMoveManager = new SlingCopyMoveManager("CopyMoveHandler");
    private final SlingDeleteManager deleteManager = new SlingDeleteManager("DeleteHandler");
    private SlingResourceConfig resourceConfig;
    private DavLocatorFactory locatorFactory;
    private SessionProvider sessionProvider;
    private boolean simpleWebDavServletRegistered;

    @Override
    public void init() throws ServletException {
        super.init();
        this.setResourceConfig(this.resourceConfig);
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DavLocatorFactory getLocatorFactory() {
        if (this.locatorFactory == null) {
            SlingRepository slingRepo = (SlingRepository)this.getRepository();
            String workspace = slingRepo.getDefaultWorkspace();
            if (workspace == null || workspace.length() == 0) {
                Session tmp = null;
                try {
                    tmp = slingRepo.login();
                    workspace = tmp.getWorkspace().getName();
                }
                catch (Throwable t) {
                    workspace = "default";
                }
                finally {
                    if (tmp != null) {
                        tmp.logout();
                    }
                }
            }
            this.locatorFactory = new SlingLocatorFactory(workspace);
        }
        return this.locatorFactory;
    }

    @Override
    public synchronized SessionProvider getSessionProvider() {
        if (this.sessionProvider == null) {
            this.sessionProvider = new SlingSessionProvider();
        }
        return this.sessionProvider;
    }

    @Activate
    protected void activate(ComponentContext context, Config config) throws NamespaceException, ServletException {
        this.ioManager.setComponentContext(context);
        this.propertyManager.setComponentContext(context);
        this.copyMoveManager.setComponentContext(context);
        this.deleteManager.setComponentContext(context);
        this.resourceConfig = new SlingResourceConfig(this.mimeTypeService, config, this.ioManager, this.propertyManager, this.copyMoveManager, this.deleteManager);
        SlingSimpleWebDavServlet simpleServlet = new SlingSimpleWebDavServlet(this.resourceConfig, this.getRepository());
        this.httpService.registerServlet(this.resourceConfig.getServletContextPath(), (Servlet)simpleServlet, this.resourceConfig.getServletInitParams(), null);
        this.simpleWebDavServletRegistered = true;
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (this.simpleWebDavServletRegistered) {
            this.httpService.unregister(this.resourceConfig.getServletContextPath());
            this.simpleWebDavServletRegistered = false;
        }
        this.resourceConfig = null;
        this.ioManager.setComponentContext(null);
        this.propertyManager.setComponentContext(null);
        this.copyMoveManager.setComponentContext(null);
        this.deleteManager.setComponentContext(null);
    }

    public void bindIOHandler(ServiceReference ioHandlerReference) {
        this.ioManager.bindIOHandler(ioHandlerReference);
    }

    public void unbindIOHandler(ServiceReference ioHandlerReference) {
        this.ioManager.unbindIOHandler(ioHandlerReference);
    }

    public void bindPropertyHandler(ServiceReference propertyHandlerReference) {
        this.propertyManager.bindPropertyHandler(propertyHandlerReference);
    }

    public void unbindPropertyHandler(ServiceReference propertyHandlerReference) {
        this.propertyManager.unbindPropertyHandler(propertyHandlerReference);
    }

    public void bindCopyMoveHandler(ServiceReference copyMoveHandlerReference) {
        this.copyMoveManager.bindCopyMoveHandler(copyMoveHandlerReference);
    }

    public void unbindCopyMoveHandler(ServiceReference copyMoveHandlerReference) {
        this.copyMoveManager.unbindCopyMoveHandler(copyMoveHandlerReference);
    }

    public void bindDeleteHandler(ServiceReference deleteHandlerReference) {
        this.deleteManager.bindDeleteHandler(deleteHandlerReference);
    }

    public void unbindDeleteHandler(ServiceReference deleteHandlerReference) {
        this.deleteManager.unbindDeleteHandler(deleteHandlerReference);
    }

    protected void sendUnauthorized(WebdavRequest request, WebdavResponse response, DavException error) throws IOException {
        response.setHeader("WWW-Authenticate", this.getAuthenticateHeaderValue());
        response.setStatus(401);
        if (error != null) {
            response.getWriter().write(error.getStatusPhrase());
            response.getWriter().write("\n");
        }
        response.getWriter().flush();
    }

    @ObjectClassDefinition(name="%dav.name", description="%dav.description")
    public static @interface Config {
        @AttributeDefinition(name="%dav.root.name", description="%dav.root.description")
        public String dav_root() default "/dav";

        @AttributeDefinition(name="%dav.create-absolute-uri.name", description="%dav.create-absolute-uri.description")
        public boolean dav_create$_$absolute$_$uri() default true;

        @AttributeDefinition(name="%dav.realm.name", description="%dav.realm.description")
        public String dav_realm() default "Sling WebDAV";

        @AttributeDefinition(name="%collection.types.name", description="%collection.types.description")
        public String[] collection_types() default {"nt:file", "nt:resource"};

        @AttributeDefinition(name="%filter.prefixes.name", description="%filter.prefixes.description")
        public String[] filter_prefixes() default {"rep", "jcr"};

        @AttributeDefinition(name="%filter.types.name", description="%filter.types.description")
        public String[] filter_types() default {};

        @AttributeDefinition(name="%filter.uris.name", description="%filter.uris.description")
        public String[] filter_uris() default {};

        @AttributeDefinition(name="%type.collections.name", description="%type.collections.description")
        public String type_collections() default "sling:Folder";

        @AttributeDefinition(name="%type.noncollections.name", description="%type.noncollections.description")
        public String type_noncollections() default "nt:file";

        @AttributeDefinition(name="%type.content.name", description="%type.content.description")
        public String type_content() default "nt:resource";
    }
}

