/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.samples.impl;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true, immediate=true)
@Properties(value={@Property(name="hc.name"), @Property(name="hc.tags", unbounded=PropertyUnbounded.ARRAY), @Property(name="hc.mbean.name")})
@Service(value={HealthCheck.class})
public class SlowHealthCheckSample
implements HealthCheck {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger counter = new AtomicInteger();
    private long minExecutionTime;
    private long maxExecutionTime;
    @Property(label="Minimum execution time", description="Shortest execution time in milliseconds", intValue={1000})
    private static final String PROP_MIN_EXEC_TIME = "execution.time.min.msec";
    private static final int DEFAULT_MIN_EXEC_TIME = 1000;
    @Property(label="Maximum execution time", description="Longest execution time in milliseconds", intValue={5000})
    private static final String PROP_MAX_EXEC_TIME = "execution.time.max.msec";
    private static final int DEFAULT_MAX_EXEC_TIME = 5000;

    public String toString() {
        return this.getClass().getSimpleName() + ", execution time=" + this.minExecutionTime + ".." + this.maxExecutionTime + " msec";
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        this.minExecutionTime = PropertiesUtil.toInteger((Object)config.get(PROP_MIN_EXEC_TIME), (int)1000);
        this.maxExecutionTime = PropertiesUtil.toInteger((Object)config.get(PROP_MAX_EXEC_TIME), (int)5000);
        this.log.debug("{} activated", (Object)this);
    }

    @Deactivate
    protected void deactivate(Map<String, Object> config) {
        this.log.debug("{} deactivated", (Object)this);
    }

    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        try {
            long randomDelay = (long)(Math.random() * (double)(this.maxExecutionTime - this.minExecutionTime));
            long toSleep = this.minExecutionTime + randomDelay;
            resultLog.debug("Executing {} will last {} msec", new Object[]{this, toSleep});
            Thread.sleep(toSleep);
        }
        catch (InterruptedException iex) {
            resultLog.warn("{} during execution", new Object[]{iex.getClass().getSimpleName()});
        }
        String execMsg = "Done executing, execution counter=" + this.counter.incrementAndGet();
        resultLog.debug("{}:{}", new Object[]{this, execMsg});
        this.log.debug("{}:{}", (Object)this, (Object)execMsg);
        return new Result((ResultLog)resultLog);
    }
}

