/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.util;

import java.util.Comparator;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.Value;

public class ValueComparator
implements Comparator<Value> {
    private static final ValueComparator INSTANCE = new ValueComparator();

    private ValueComparator() {
    }

    public static ValueComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(Value o1, Value o2) {
        try {
            switch (o1.getType()) {
                case 2: {
                    throw new IllegalArgumentException("sorting of binary values not supported.");
                }
                case 5: {
                    return o1.getDate().compareTo(o2.getDate());
                }
                case 12: {
                    return o1.getDecimal().compareTo(o2.getDecimal());
                }
                case 4: {
                    return Double.valueOf(o1.getDouble()).compareTo(o2.getDouble());
                }
                case 3: {
                    return Long.valueOf(o1.getLong()).compareTo(o2.getLong());
                }
            }
            return o1.getString().compareTo(o2.getString());
        }
        catch (RepositoryException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

