/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import relocated_for_contentpackage.javax.jcr.Node;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.Artifact;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.ImportMode;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.SerializationType;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io.AbstractArtifactHandler;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io.DocViewSAXImporter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.spi.ACLManagement;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.spi.ServiceProviderFactory;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.spi.UserManagement;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.PathUtil;

public class GenericArtifactHandler
extends AbstractArtifactHandler {
    private static final Logger log = LoggerFactory.getLogger(GenericArtifactHandler.class);
    private UserManagement userManagement = ServiceProviderFactory.getProvider().getUserManagement();
    private ACLManagement aclManagement = ServiceProviderFactory.getProvider().getACLManagement();

    @Override
    public ImportInfoImpl accept(WorkspaceFilter wspFilter, Node parent, String name, ArtifactSetImpl artifacts) throws RepositoryException, IOException {
        Artifact primary = artifacts.getPrimaryData();
        if (primary == null) {
            return null;
        }
        ImportInfoImpl info = null;
        VaultInputSource source = primary.getInputSource();
        if (source != null && primary.getSerializationType() == SerializationType.XML_DOCVIEW) {
            info = new ImportInfoImpl();
            String path = PathUtil.getPath(parent, name);
            if ((name.length() == 0 || parent.hasNode(name)) && wspFilter.getImportMode(path) == ImportMode.MERGE) {
                Node newNode = parent.getNode(name);
                if (this.userManagement.isAuthorizableNodeType(newNode.getPrimaryNodeType().getName())) {
                    log.trace("don't skip authorizable node on MERGE: {}", (Object)path);
                } else if (this.aclManagement.isACLNode(newNode)) {
                    log.trace("don't skip policy node on MERGE: {}", (Object)path);
                } else {
                    info.onNop(path);
                    return info;
                }
            }
            try {
                DocViewSAXImporter handler = new DocViewSAXImporter(parent, name, artifacts, wspFilter);
                handler.setAclHandling(this.getAcHandling());
                handler.setCugHandling(this.getCugHandling());
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
                SAXParser parser = factory.newSAXParser();
                parser.parse((InputSource)source, (DefaultHandler)handler);
                info.merge(handler.getInfo());
            }
            catch (ParserConfigurationException e) {
                throw new RepositoryException(e);
            }
            catch (SAXException e) {
                info = new ImportInfoImpl();
                info.onError(path, e);
                log.error("Error while parsing {}: {}", (Object)source.getSystemId(), (Object)e);
            }
        }
        return info;
    }
}

