/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.Artifact;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.ArtifactType;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.DumpContext;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.PathUtil;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.PlatformNameFormat;

public abstract class AbstractArtifact
implements Artifact {
    private final String repoRelPath;
    private String platRelPath;
    private final String extension;
    private final ArtifactType type;
    private String contentType;

    protected AbstractArtifact(Artifact parent, String repoRelPath, String extension, ArtifactType type) {
        this.type = type;
        this.extension = extension;
        if (parent == null) {
            this.repoRelPath = repoRelPath;
            this.platRelPath = PlatformNameFormat.getPlatformPath(repoRelPath + extension);
        } else {
            this.repoRelPath = PathUtil.append(parent.getRelativePath(), repoRelPath);
            this.platRelPath = PathUtil.append(parent.getPlatformPath(), PlatformNameFormat.getPlatformPath(repoRelPath + extension));
        }
        if (this.platRelPath.equals(this.repoRelPath)) {
            this.platRelPath = null;
        }
    }

    protected AbstractArtifact(Artifact base, ArtifactType type) {
        this.type = type;
        this.extension = base.getExtension();
        this.repoRelPath = base.getRelativePath();
        this.platRelPath = base.getPlatformPath();
        this.contentType = base.getContentType();
    }

    @Override
    public String getRelativePath() {
        return this.repoRelPath;
    }

    @Override
    public String getPlatformPath() {
        return this.platRelPath == null ? this.repoRelPath : this.platRelPath;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public ArtifactType getType() {
        return this.type;
    }

    @Override
    public void spool(OutputStream out) throws IOException, RepositoryException {
        try (InputStream in = this.getInputStream();){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer)) >= 0) {
                out.write(buffer, 0, read);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.type.toString());
        buf.append('(').append(this.repoRelPath).append(')');
        return buf.toString();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int hashCode() {
        return this.repoRelPath.hashCode() + 37 * this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Artifact) {
            Artifact a = (Artifact)obj;
            return this.getRelativePath().equals(a.getRelativePath()) && this.type == a.getType();
        }
        return false;
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, "Artifact");
        ctx.indent(isLast);
        ctx.printf(false, "rel path: %s", this.getRelativePath());
        ctx.printf(false, "plt path: %s", this.getPlatformPath());
        ctx.printf(false, "type: %s", new Object[]{this.getType()});
        ctx.printf(false, "serialization: %s", new Object[]{this.getSerializationType()});
        ctx.printf(false, "access type: %s", new Object[]{this.getPreferredAccess()});
        ctx.printf(false, "content type: %s", this.getContentType());
        ctx.printf(true, "content length: %d", this.getContentLength());
        ctx.outdent();
    }
}

