/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.filter;

import relocated_for_contentpackage.javax.jcr.Item;
import relocated_for_contentpackage.javax.jcr.Node;
import relocated_for_contentpackage.javax.jcr.Property;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.DumpContext;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.filter.DepthItemFilter;

public class DeclaringTypeItemFilter
extends DepthItemFilter {
    private String nodeType;
    private boolean propsOnly;

    public DeclaringTypeItemFilter() {
    }

    public DeclaringTypeItemFilter(String nodeType, boolean propsOnly, int minDepth, int maxDepth) {
        super(minDepth, maxDepth);
        this.nodeType = nodeType;
        this.propsOnly = propsOnly;
    }

    public DeclaringTypeItemFilter(String nodeType, boolean propsOnly) {
        this(nodeType, propsOnly, 0, Integer.MAX_VALUE);
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public void setPropsOnly(String propsOnly) {
        this.propsOnly = Boolean.valueOf(propsOnly);
    }

    @Override
    public boolean matches(Item item) throws RepositoryException {
        if (item.isNode()) {
            return !this.propsOnly && ((Node)item).getDefinition().getDeclaringNodeType().getName().equals(this.nodeType);
        }
        return ((Property)item).getDefinition().getDeclaringNodeType().getName().equals(this.nodeType);
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        super.dump(ctx, isLast);
        ctx.indent(isLast);
        ctx.printf(false, "nodeType: %s", this.nodeType);
        ctx.printf(true, "propsOnly: %b", this.propsOnly);
        ctx.outdent();
    }
}

