/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.AccessType;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.Artifact;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.VaultFile;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.BinaryCheckOutputStream;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.LineOutputStream;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.MD5;

public class VaultFileCopy {
    private final VaultFile remoteFile;
    private final File localFile;
    private final MessageDigest digest;
    private byte[] lineFeed = null;
    private MD5 md5 = null;
    private long length;
    private boolean binary;

    private VaultFileCopy(VaultFile remote, File local, MessageDigest digest, byte[] lineFeed) {
        this.remoteFile = remote;
        this.localFile = local;
        this.digest = digest;
        this.lineFeed = lineFeed;
    }

    public static VaultFileCopy copy(VaultFile remote, File local) throws IOException {
        return VaultFileCopy.copy(remote, local, null);
    }

    public static VaultFileCopy copy(VaultFile remote, File local, byte[] lineFeed) throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        VaultFileCopy copy = new VaultFileCopy(remote, local, md, lineFeed);
        try {
            copy.run();
        }
        catch (RepositoryException e) {
            throw new IOException(e.toString());
        }
        return copy;
    }

    private void run() throws IOException, RepositoryException {
        Artifact a = this.remoteFile.getArtifact();
        if (a.getPreferredAccess() == AccessType.NONE) {
            throw new IOException("Artifact has no content.");
        }
        OutputStream base = this.digest == null ? new FileOutputStream(this.localFile) : new DigestOutputStream(new FileOutputStream(this.localFile), this.digest);
        if (this.lineFeed != null) {
            base = new LineOutputStream(base, this.lineFeed);
        }
        try (BinaryCheckOutputStream out = new BinaryCheckOutputStream(base);){
            switch (a.getPreferredAccess()) {
                case SPOOL: {
                    a.spool(out);
                    break;
                }
                case STREAM: {
                    InputStream in = a.getInputStream();
                    try {
                        int read;
                        byte[] buffer = new byte[8192];
                        while ((read = in.read(buffer)) >= 0) {
                            out.write(buffer, 0, read);
                        }
                        if (in == null) break;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    in.close();
                    break;
                }
            }
            this.binary = out.isBinary();
        }
        this.length = this.localFile.length();
        long lastMod = this.remoteFile.lastModified();
        if (lastMod > 0L) {
            this.localFile.setLastModified(lastMod);
        }
        if (this.digest != null) {
            this.md5 = new MD5(this.digest.digest());
        }
    }

    public MD5 getMd5() {
        return this.md5;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isBinary() {
        return this.binary;
    }
}

