/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.security.authorization.jackrabbit.acl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.operation.AddNode;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.Remove;
import org.apache.jackrabbit.jcr2spi.operation.SetMixin;
import org.apache.jackrabbit.jcr2spi.operation.SetTree;
import org.apache.jackrabbit.jcr2spi.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.jcr2spi.security.authorization.jackrabbit.AccessControlConstants;
import org.apache.jackrabbit.jcr2spi.security.authorization.jackrabbit.acl.AccessControlEntryImpl;
import org.apache.jackrabbit.jcr2spi.security.authorization.jackrabbit.acl.AccessControlListImpl;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.UpdatableItemStateManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NameParser;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AccessControlManagerImpl
implements AccessControlManager,
AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(AccessControlManagerImpl.class);
    private static int REMOVE_POLICY_OPTIONS = 39;
    private final SessionInfo sessionInfo;
    private final HierarchyManager hierarchyManager;
    private final NamePathResolver npResolver;
    private final QValueFactory qvf;
    private final AccessControlProvider acProvider;
    private final UpdatableItemStateManager itemStateMgr;
    private final ItemDefinitionProvider definitionProvider;

    AccessControlManagerImpl(SessionInfo sessionInfo, UpdatableItemStateManager itemStateMgr, ItemDefinitionProvider definitionProvider, HierarchyManager hierarchyManager, NamePathResolver npResolver, QValueFactory qvf, AccessControlProvider acProvider) {
        this.sessionInfo = sessionInfo;
        this.hierarchyManager = hierarchyManager;
        this.itemStateMgr = itemStateMgr;
        this.npResolver = npResolver;
        this.qvf = qvf;
        this.acProvider = acProvider;
        this.definitionProvider = definitionProvider;
    }

    public Privilege[] getSupportedPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        NodeState state = this.getNodeState(this.npResolver.getQPath(absPath));
        Map<String, Privilege> privileges = this.acProvider.getSupportedPrivileges(this.sessionInfo, state.getNodeId(), this.npResolver);
        return privileges.values().toArray(new Privilege[privileges.size()]);
    }

    public Privilege privilegeFromName(String privilegeName) throws AccessControlException, RepositoryException {
        return this.acProvider.privilegeFromName(this.sessionInfo, this.npResolver, privilegeName);
    }

    public boolean hasPrivileges(String absPath, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        List<Privilege> toTest;
        Set<Privilege> privs = this.acProvider.getPrivileges(this.sessionInfo, this.getNodeState(this.npResolver.getQPath(absPath)).getNodeId(), this.npResolver);
        if (privs.containsAll(toTest = Arrays.asList(privileges))) {
            return true;
        }
        HashSet<Privilege> agg = new HashSet<Privilege>(privs);
        for (Privilege p : privs) {
            if (!p.isAggregate()) continue;
            agg.addAll(Arrays.asList(p.getAggregatePrivileges()));
        }
        return agg.containsAll(toTest);
    }

    public Privilege[] getPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        Set<Privilege> privs = this.acProvider.getPrivileges(this.sessionInfo, this.getNodeState(this.npResolver.getQPath(absPath)).getNodeId(), this.npResolver);
        return privs.toArray(new Privilege[privs.size()]);
    }

    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws RepositoryException {
        this.checkValidNodePath(absPath);
        this.checkAccessControlRead(absPath);
        return new AccessControlPolicy[]{new AccessControlPolicy(){}};
    }

    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws RepositoryException {
        this.checkValidNodePath(absPath);
        AccessControlPolicy[] applicable = this.getApplicable(absPath);
        if (applicable != null && applicable.length > 0) {
            return new AccessControlPolicyIteratorAdapter(Arrays.asList(applicable));
        }
        return AccessControlPolicyIteratorAdapter.EMPTY;
    }

    public AccessControlPolicy[] getPolicies(String absPath) throws RepositoryException {
        this.checkValidNodePath(absPath);
        ArrayList<AccessControlListImpl> policies = new ArrayList<AccessControlListImpl>();
        NodeState aclNode = this.getAclNode(absPath);
        if (aclNode != null) {
            AccessControlListImpl acl = new AccessControlListImpl(aclNode, absPath, this.npResolver, this.qvf, this);
            policies.add(acl);
        }
        return (AccessControlPolicy[])policies.toArray(new AccessControlList[policies.size()]);
    }

    public void setPolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        SetTree operation;
        this.checkValidNodePath(absPath);
        this.checkValidPolicy(policy);
        this.checkAcccessControlItem(absPath);
        NodeState aclNode = this.getAclNode(absPath);
        if (aclNode == null) {
            Name name = absPath == null ? N_REPO_POLICY : N_POLICY;
            NodeState parent = null;
            Name mixinType = null;
            if (absPath == null) {
                parent = this.getRootNodeState();
                mixinType = NT_REP_REPO_ACCESS_CONTROLLABLE;
            } else {
                parent = this.getNodeState(absPath);
                mixinType = NT_REP_ACCESS_CONTROLLABLE;
            }
            this.setMixin(parent, mixinType);
            operation = SetTree.create(this.itemStateMgr, parent, name, NT_REP_ACL, null);
            aclNode = operation.getTreeState();
        } else {
            Iterator<NodeEntry> it = this.getNodeEntry(aclNode).getNodeEntries();
            while (it.hasNext()) {
                it.next().transientRemove();
            }
            operation = SetTree.create(aclNode);
        }
        for (AccessControlEntry entry : ((AccessControlListImpl)policy).getAccessControlEntries()) {
            this.createAceNode(operation, aclNode, entry);
        }
        this.itemStateMgr.execute(operation);
    }

    public void removePolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        this.checkValidNodePath(absPath);
        this.checkValidPolicy(policy);
        NodeState aclNode = this.getAclNode(absPath);
        if (aclNode == null) {
            throw new AccessControlException("No policy exist at " + absPath);
        }
        this.removeNode(aclNode);
    }

    private AccessControlPolicy[] getApplicable(String absPath) throws RepositoryException {
        AccessControlPolicy[] accessControlPolicyArray;
        NodeState controlledState = absPath == null ? this.getRootNodeState() : this.getNodeState(absPath);
        AccessControlListImpl acl = null;
        NodeState aclNode = this.getAclNode(controlledState, absPath);
        if (aclNode == null) {
            acl = new AccessControlListImpl(absPath, this.npResolver, this.qvf);
        }
        if (acl == null) {
            accessControlPolicyArray = new AccessControlPolicy[]{};
        } else {
            AccessControlPolicy[] accessControlPolicyArray2 = new AccessControlPolicy[1];
            accessControlPolicyArray = accessControlPolicyArray2;
            accessControlPolicyArray2[0] = acl;
        }
        return accessControlPolicyArray;
    }

    private NodeState getAclNode(String controlledNodePath) throws RepositoryException {
        NodeState controlledNode = controlledNodePath == null ? this.getRootNodeState() : this.getNodeState(controlledNodePath);
        return this.getAclNode(controlledNode, controlledNodePath);
    }

    private NodeState getAclNode(NodeState aclNode, String controlledNodePath) throws RepositoryException {
        NodeState acl = null;
        if (controlledNodePath == null) {
            if (this.isRepoAccessControlled(aclNode)) {
                acl = aclNode.getChildNodeState(N_REPO_POLICY, 1);
            }
        } else if (this.isAccessControlled(aclNode)) {
            acl = aclNode.getChildNodeState(N_POLICY, 1);
        }
        return acl;
    }

    private boolean isRepoAccessControlled(NodeState nodeState) throws RepositoryException {
        return this.isNodeType(nodeState, NT_REP_REPO_ACCESS_CONTROLLABLE) && nodeState.hasChildNodeEntry(N_REPO_POLICY, 1);
    }

    private boolean isAccessControlled(NodeState nodeState) throws RepositoryException {
        return this.isNodeType(nodeState, NT_REP_ACCESS_CONTROLLABLE) && nodeState.hasChildNodeEntry(N_POLICY, 1);
    }

    private boolean isNodeType(NodeState nodeState, Name mixinName) throws RepositoryException {
        List<Name> lst = Arrays.asList(nodeState.getAllNodeTypeNames());
        return lst == null ? false : lst.contains(mixinName);
    }

    private void checkAcccessControlItem(String nodePath) throws AccessControlException, RepositoryException {
        boolean isAcItem;
        NodeState controlledState = this.getNodeState(nodePath);
        Name ntName = controlledState.getNodeTypeName();
        boolean bl = isAcItem = ntName.equals(NT_REP_ACL) || ntName.equals(NT_REP_GRANT_ACE) || ntName.equals(NT_REP_DENY_ACE);
        if (isAcItem) {
            throw new AccessControlException("The path: " + nodePath + " points to an access control content node");
        }
    }

    private void checkAccessControlRead(String absPath) throws RepositoryException {
        if (!this.hasPrivileges(absPath, new Privilege[]{this.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl")})) {
            throw new AccessDeniedException();
        }
    }

    private void createAceNode(SetTree operation, NodeState parentState, AccessControlEntry entry) throws RepositoryException {
        AccessControlEntryImpl ace = (AccessControlEntryImpl)entry;
        String uuid = null;
        boolean isAllow = ace.isAllow();
        Name nodeName = this.getUniqueNodeName(parentState, isAllow ? "allow" : "deny");
        Name nodeTypeName = isAllow ? NT_REP_GRANT_ACE : NT_REP_DENY_ACE;
        NodeState aceNode = this.addNode(operation, parentState, nodeName, uuid, nodeTypeName);
        String valueStr = ace.getPrincipal().getName();
        QValue value = this.qvf.create(valueStr, 1);
        this.addProperty(operation, aceNode, N_REP_PRINCIPAL_NAME, 1, new QValue[]{value});
        Privilege[] privs = ace.getPrivileges();
        QValue[] vls = new QValue[privs.length];
        Name privilegeName = null;
        try {
            for (int i = 0; i < privs.length; ++i) {
                privilegeName = this.npResolver.getQName(privs[i].getName());
                vls[i] = this.qvf.create(privilegeName.toString(), 7);
            }
        }
        catch (ValueFormatException e) {
            throw new RepositoryException(e.getMessage());
        }
        this.addProperty(operation, aceNode, N_REP_PRIVILEGES, 7, vls);
    }

    private NodeState getNodeState(String nodePath) throws RepositoryException {
        return this.getNodeState(this.npResolver.getQPath(nodePath));
    }

    private NodeState getRootNodeState() throws RepositoryException {
        return this.hierarchyManager.getRootEntry().getNodeState();
    }

    private NodeState getNodeState(Path qPath) throws RepositoryException {
        return this.hierarchyManager.getNodeState(qPath);
    }

    private NodeEntry getNodeEntry(NodeState nodeState) throws RepositoryException {
        return this.hierarchyManager.getNodeEntry(nodeState.getPath());
    }

    private void checkValidNodePath(String absPath) throws PathNotFoundException, RepositoryException {
        if (absPath != null) {
            Path qPath = this.npResolver.getQPath(absPath);
            if (!qPath.isAbsolute()) {
                throw new RepositoryException("Absolute path expected. Found: " + absPath);
            }
            if (this.hierarchyManager.getNodeEntry(qPath).getNodeState() == null) {
                throw new PathNotFoundException(absPath);
            }
        }
    }

    private void checkValidPolicy(AccessControlPolicy policy) throws AccessControlException {
        if (policy == null || !(policy instanceof AccessControlListImpl)) {
            throw new AccessControlException("Policy is not applicable ");
        }
    }

    private NodeState addNode(SetTree treeOperation, NodeState parent, Name nodeName, String uuid, Name nodeTypeName) throws RepositoryException {
        Operation sp = treeOperation.addChildNode(parent, nodeName, nodeTypeName, uuid);
        this.itemStateMgr.execute(sp);
        return (NodeState)((AddNode)sp).getAddedStates().get(0);
    }

    private void addProperty(SetTree treeOperation, NodeState parent, Name propName, int propType, QValue[] values) throws RepositoryException {
        QPropertyDefinition definition = this.definitionProvider.getQPropertyDefinition(parent.getAllNodeTypeNames(), propName, propType);
        Operation ap = treeOperation.addChildProperty(parent, propName, propType, values, definition);
        this.itemStateMgr.execute(ap);
    }

    private void removeNode(NodeState aclNode) throws RepositoryException {
        Operation removePolicy = Remove.create(aclNode, REMOVE_POLICY_OPTIONS);
        this.itemStateMgr.execute(removePolicy);
    }

    private void setMixin(NodeState parent, Name mixinName) throws RepositoryException {
        if (!this.isNodeType(parent, mixinName)) {
            Operation sm = SetMixin.create(parent, new Name[]{mixinName});
            this.itemStateMgr.execute(sm);
        } else {
            log.debug(mixinName.toString() + " is already present on the given node state " + parent.getName().toString());
        }
    }

    private Name getUniqueNodeName(NodeState node, String name) throws RepositoryException {
        try {
            NameParser.checkFormat((String)name);
        }
        catch (NameException e) {
            log.debug("Invalid path name for Permission: " + name + ".");
        }
        int i = 0;
        String check = name;
        Name n = this.npResolver.getQName(check);
        while (node.hasChildNodeEntry(n, 1)) {
            check = name + i;
            n = this.npResolver.getQName(check);
            ++i;
        }
        return n;
    }
}

