/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.security.authorization;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.PrivilegeDefinition;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

public class PrivilegeImpl
implements Privilege {
    private final PrivilegeDefinition definition;
    private final Privilege[] declaredAggregates;
    private final Privilege[] aggregates;
    private static final Privilege[] EMPTY_ARRAY = new Privilege[0];
    private final NamePathResolver npResolver;

    public PrivilegeImpl(PrivilegeDefinition definition, PrivilegeDefinition[] allDefs, NamePathResolver npResolver) throws RepositoryException {
        this.definition = definition;
        this.npResolver = npResolver;
        Set set = definition.getDeclaredAggregateNames();
        Name[] declAggrNames = set.toArray(new Name[set.size()]);
        if (declAggrNames.length == 0) {
            this.declaredAggregates = EMPTY_ARRAY;
            this.aggregates = EMPTY_ARRAY;
        } else {
            this.declaredAggregates = new Privilege[declAggrNames.length];
            for (int i = 0; i < declAggrNames.length; ++i) {
                for (PrivilegeDefinition privilegeDefinition : allDefs) {
                    if (!privilegeDefinition.getName().equals(declAggrNames[i])) continue;
                    this.declaredAggregates[i] = new PrivilegeImpl(privilegeDefinition, allDefs, npResolver);
                }
            }
            HashSet<Object> aggr = new HashSet<Object>();
            for (PrivilegeDefinition privilegeDefinition : this.declaredAggregates) {
                aggr.add(privilegeDefinition);
                if (!privilegeDefinition.isAggregate()) continue;
                aggr.addAll(Arrays.asList(privilegeDefinition.getAggregatePrivileges()));
            }
            this.aggregates = aggr.toArray(new Privilege[aggr.size()]);
        }
    }

    public String getName() {
        try {
            return this.npResolver.getJCRName(this.definition.getName());
        }
        catch (NamespaceException e) {
            return this.definition.getName().toString();
        }
    }

    public boolean isAbstract() {
        return this.definition.isAbstract();
    }

    public boolean isAggregate() {
        return this.declaredAggregates.length > 0;
    }

    public Privilege[] getDeclaredAggregatePrivileges() {
        return this.declaredAggregates;
    }

    public Privilege[] getAggregatePrivileges() {
        return this.aggregates;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PrivilegeImpl) {
            PrivilegeImpl other = (PrivilegeImpl)obj;
            return this.definition.equals(other.definition);
        }
        return false;
    }
}

