/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.format;

import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.format.MediaFormat;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class Ratio {
    private Ratio() {
    }

    public static boolean matches(double first, double second) {
        return first > second - 0.05 && first < second + 0.05;
    }

    public static boolean matches(@NotNull MediaFormat first, @NotNull MediaFormat second) {
        if (!first.hasRatio() || !second.hasRatio()) {
            return false;
        }
        return Ratio.matches(first.getRatio(), second.getRatio());
    }

    public static double get(double width, double height) {
        if (width <= 0.0) {
            return 0.0;
        }
        if (height <= 0.0) {
            return 0.0;
        }
        return width / height;
    }

    public static double get(long width, long height) {
        return Ratio.get((double)width, (double)height);
    }

    public static double get(@NotNull Dimension dimension) {
        return Ratio.get(dimension.getWidth(), dimension.getHeight());
    }
}

