/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.BundleDescriptor;

public class CheckDuplicateSymbolicName
implements AnalyserTask {
    @Override
    public String getName() {
        return "Duplicate Symbolic Name";
    }

    @Override
    public String getId() {
        return "duplicate-symbolic-names";
    }

    private SortedMap<String, Set<ArtifactId>> createBundleMap(AnalyserTaskContext ctx) {
        TreeMap<String, Set<ArtifactId>> bundleMap = new TreeMap<String, Set<ArtifactId>>();
        for (BundleDescriptor desc : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            String key = desc.getBundleSymbolicName();
            Set set = bundleMap.computeIfAbsent(key, id -> new HashSet());
            set.add(desc.getArtifact().getId());
        }
        return bundleMap;
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws Exception {
        SortedMap<String, Set<ArtifactId>> bundleMap = this.createBundleMap(ctx);
        for (Map.Entry<String, Set<ArtifactId>> entry : bundleMap.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("Duplicate symbolic name ");
            sb.append(entry.getKey());
            sb.append(" : ");
            boolean first = true;
            for (ArtifactId id : entry.getValue()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(id.toMvnId());
            }
            ctx.reportError(sb.toString());
        }
    }
}

