/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.extensions.webconsolesecurityprovider.internal;

import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.WebConsoleSecurityProvider3;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.auth.Authenticator;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.auth.core.AuthenticationSupport;
import org.apache.sling.extensions.webconsolesecurityprovider.internal.AbstractWebConsoleSecurityProvider;

public class SlingWebConsoleSecurityProvider2
extends AbstractWebConsoleSecurityProvider
implements WebConsoleSecurityProvider3 {
    private final AuthenticationSupport authentiationSupport;
    private final Authenticator authenticator;

    public SlingWebConsoleSecurityProvider2(Object support, Object authenticator) {
        this.authentiationSupport = (AuthenticationSupport)support;
        this.authenticator = (Authenticator)authenticator;
    }

    public boolean authenticate(HttpServletRequest request, HttpServletResponse response) {
        if (this.authentiationSupport.handleSecurity(request, response)) {
            Session session;
            ResourceResolver resolver;
            Object resolverObject = request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
            ResourceResolver resourceResolver = resolver = resolverObject instanceof ResourceResolver ? (ResourceResolver)resolverObject : null;
            if (resolver != null && (session = (Session)resolver.adaptTo(Session.class)) != null) {
                try {
                    User u = this.authenticate(session);
                    if (u != null) {
                        request.setAttribute("org.apache.felix.webconsole.user", (Object)u);
                        return true;
                    }
                }
                catch (Exception re) {
                    this.logger.info("authenticate: Generic problem trying grant User  access to the Web Console", (Throwable)re);
                }
            }
            if (request.getAuthType() == null) {
                this.authenticator.login(request, response);
            }
        }
        return false;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        this.authenticator.logout(request, response);
    }

    public User authenticate(String userName, String password) {
        return null;
    }

    private User authenticate(Session session) throws RepositoryException {
        String userId = session.getUserID();
        if (session instanceof JackrabbitSession) {
            UserManager umgr = ((JackrabbitSession)session).getUserManager();
            Authorizable a = umgr.getAuthorizable(userId);
            if (a instanceof User) {
                if (this.users.contains(userId)) {
                    return (User)a;
                }
                Iterator gi = a.memberOf();
                while (gi.hasNext()) {
                    if (!this.groups.contains(((Group)gi.next()).getID())) continue;
                    return (User)a;
                }
                this.logger.info("authenticate: User {} is denied Web Console access", (Object)userId);
            } else {
                this.logger.error("authenticate: Expected user ID {} to refer to a user", (Object)userId);
            }
        } else {
            this.logger.info("authenticate: Jackrabbit Session required to grant access to the Web Console for {}; got {}", (Object)userId, session.getClass());
        }
        return null;
    }

    public boolean authorize(Object user, String role) {
        this.logger.debug("authorize: Grant user {} access for role {}", user, (Object)role);
        return true;
    }
}

