/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.kafka;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.sling.distribution.journal.MessageInfo;

public class KafkaMessageInfo
implements MessageInfo {
    public static final String KEY_MESSAGE_TYPE = "messageType";
    private final String topic;
    private final int partition;
    private final long offset;
    private final long createTime;
    private final Map<String, String> props;

    public KafkaMessageInfo(ConsumerRecord<String, ?> record) {
        this(record, Collections.emptyMap());
    }

    public KafkaMessageInfo(ConsumerRecord<String, ?> record, Map<String, String> props) {
        this.props = props;
        this.topic = record.topic();
        this.partition = record.partition();
        this.offset = record.offset();
        this.createTime = record.timestamp();
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public String toString() {
        return String.format("Topic: %s, Partition: %d, Offset: %d, CreateTime: %d", this.topic, this.partition, this.offset, this.createTime);
    }
}

