/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.publisher;

import java.util.Hashtable;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.impl.discovery.TopologyChangeHandler;
import org.apache.sling.distribution.journal.impl.publisher.PackageDistributedNotifier;
import org.apache.sling.distribution.journal.queue.PubQueueProvider;
import org.apache.sling.distribution.journal.shared.Topics;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(immediate=true, service={TopologyEventListener.class, Runnable.class}, property={"scheduler.concurrent:Boolean=false", "scheduler.immediate:Boolean=true", "scheduler.period:Long=600", "scheduler.runOn=LEADER"})
@Designate(ocd=Configuration.class)
public class DistributedEventNotifierManager
implements TopologyEventListener,
Runnable {
    @Reference
    private EventAdmin eventAdmin;
    @Reference
    private PubQueueProvider pubQueueCacheService;
    @Reference
    private MessagingProvider messagingProvider;
    @Reference
    private Topics topics;
    @Reference
    private ResourceResolverFactory resolverFactory;
    private ServiceRegistration<TopologyChangeHandler> reg;
    private BundleContext context;
    private Configuration config;
    private PackageDistributedNotifier notifier;

    @Activate
    public void activate(BundleContext context, Configuration config) {
        this.context = context;
        this.config = config;
        this.notifier = new PackageDistributedNotifier(this.eventAdmin, this.pubQueueCacheService, this.messagingProvider, this.topics, this.resolverFactory, config.ensureEvent());
        if (!config.deduplicateEvent()) {
            this.registerService();
        }
    }

    @Deactivate
    public void deactivate() {
        this.unregisterService();
    }

    public void handleTopologyEvent(TopologyEvent event) {
        if (this.config.deduplicateEvent()) {
            TopologyEvent.Type eventType = event.getType();
            if (eventType == TopologyEvent.Type.TOPOLOGY_INIT || eventType == TopologyEvent.Type.TOPOLOGY_CHANGED) {
                if (event.getNewView().getLocalInstance().isLeader()) {
                    this.registerService();
                } else {
                    this.unregisterService();
                }
            } else if (eventType == TopologyEvent.Type.TOPOLOGY_CHANGING) {
                this.unregisterService();
            }
        }
    }

    @Override
    public void run() {
        this.notifier.storeLastDistributedOffset();
    }

    protected boolean isLeader() {
        return this.reg != null;
    }

    private synchronized void registerService() {
        if (this.reg == null) {
            this.reg = this.context.registerService(TopologyChangeHandler.class, (Object)this.notifier, new Hashtable());
        }
    }

    private synchronized void unregisterService() {
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }

    @ObjectClassDefinition(name="Apache Sling Journal based Distribution - Package Distributed Event Notifier Configuration", description="Apache Sling Content Distribution Package Distributed Event Notifier Configuration")
    public static @interface Configuration {
        @AttributeDefinition(name="Deduplicate event", description="When true the distributed event will be sent only on one instance in the cluster. When false the distributed event will be sent on all instances in the cluster. Default is false")
        public boolean deduplicateEvent() default false;

        @AttributeDefinition(name="Ensure event", description="When true events will be sent from the last distributed event persisted in the repository. Default is false")
        public boolean ensureEvent() default false;
    }
}

