/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.discovery;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.journal.impl.discovery.State;
import org.apache.sling.distribution.journal.impl.discovery.TopologyView;

@ParametersAreNonnullByDefault
public class TopologyViewManager {
    private final Map<String, State> states = new ConcurrentHashMap<String, State>();
    private volatile TopologyView currentView = new TopologyView();
    private final long refreshTtl;

    public TopologyViewManager(long refreshTtl) {
        this.refreshTtl = refreshTtl;
    }

    public TopologyView getCurrentView() {
        return this.currentView;
    }

    public void refreshState(State state) {
        this.states.put(this.stateId(state), state);
    }

    public TopologyView updateView() {
        long now = System.currentTimeMillis();
        return this.updateView(now);
    }

    protected TopologyView updateView(long now) {
        TopologyView oldView = this.currentView;
        this.currentView = this.buildView(now);
        return oldView;
    }

    protected int size() {
        return this.states.size();
    }

    private TopologyView buildView(long now) {
        Set<State> newStates = this.states.values().stream().filter(e -> this.isAlive(now, (State)e)).collect(Collectors.toSet());
        return new TopologyView(newStates);
    }

    private boolean isAlive(long now, State state) {
        return now - state.getTimestamp() < this.refreshTtl;
    }

    private String stateId(State state) {
        return String.format("%s#%s", state.getSubAgentId(), state.getPubAgentName());
    }
}

