/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.test;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.DistributionResponse;
import org.apache.sling.distribution.Distributor;
import org.apache.sling.distribution.SimpleDistributionRequest;

@SlingServlet(paths={"/bin/test/distributor"})
public class DistributorServlet
extends SlingAllMethodsServlet {
    @Reference
    Distributor distributor;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        String agentName = request.getParameter("agent");
        String[] paths = request.getParameterValues("path");
        if (agentName == null) {
            response.getWriter().print("agent is required");
            return;
        }
        SimpleDistributionRequest distributionRequest = new SimpleDistributionRequest(DistributionRequestType.fromName((String)action), paths);
        DistributionResponse distributionResponse = this.distributor.distribute(agentName, request.getResourceResolver(), (DistributionRequest)distributionRequest);
        if (distributionResponse.isSuccessful()) {
            response.setStatus(200);
        } else {
            response.setStatus(400);
        }
    }

    protected void bindDistributor(Distributor distributor) {
        this.distributor = distributor;
    }

    protected void unbindDistributor(Distributor distributor) {
        if (this.distributor == distributor) {
            this.distributor = null;
        }
    }
}

