/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.distribution.monitor.impl;

/**
 * The QueueDistributionAgent MBean definition.
 */
public interface QueueDistributionAgentMBean {

    /**
     * The name of the agent.
     *
     * @return the Name
     */
    String getName();

    /**
     * The display friendly title of the agent.
     *
     * @return the Title
     */
    String getTitle();

    /**
     * The display friendly details of the agent.
     *
     * @return the Details
     */
    String getDetails();

    /**
     * Whether or not to start the distribution agent.
     *
     * @return the Enabled
     */
    boolean isEnabled();

    /**
     * The name of the service used to access the repository.
     *
     * @return the Service Name
     */
    String getServiceName();

    /**
     * The log level recorded in the transient log accessible via http.
     *
     * @return the Log Level
     */
    String getLogLevel();

    /**
     * If set the agent will allow only distribution requests under the specified roots.
     *
     * @return the Allowed roots
     */
    String getAllowedRoots();

    /**
     * List of priority queues that should used for specific paths.The selector format is  {queuePrefix}[|{mainQueueMatcher}]={pathMatcher}, e.g. french=/content/fr.*
     *
     * @return the Priority queues
     */
    String getPriorityQueues();

    /**
     * The distribution agent status, usually one of:
     * paused
     * idle
     * running
     * blocked
     *
     *
     * @return the distribution agent status
     * @see org.apache.sling.distribution.agent.DistributionAgentState
     */
    String getStatus();

}
