/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class LogSilencer {
    private static final long DEFAULT_AUTO_RESET_DELAY_MINUTES = 10L;
    private final Logger logger;
    private final Object syncObj = new Object();
    private final long autoResetDelayMillis;
    private Map<String, String> lastMsgPerCategory;
    private long autoResetTime = 0L;

    public LogSilencer(Logger logger, long autoResetDelayMinutes) {
        this.logger = logger;
        this.autoResetDelayMillis = autoResetDelayMinutes > 0L ? TimeUnit.MINUTES.toMillis(autoResetDelayMinutes) : 0L;
    }

    public LogSilencer(Logger logger) {
        this(logger, 10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void infoOrDebug(String category, String msg) {
        boolean doLogInfo;
        Object object = this.syncObj;
        synchronized (object) {
            String localLastMsg;
            if (this.autoResetTime == 0L || System.currentTimeMillis() > this.autoResetTime) {
                this.reset();
            }
            if (this.lastMsgPerCategory == null) {
                this.lastMsgPerCategory = new HashMap<String, String>();
            }
            if ((localLastMsg = this.lastMsgPerCategory.get(category)) == null || !localLastMsg.equals(msg)) {
                doLogInfo = true;
                this.lastMsgPerCategory.put(category, msg);
            } else {
                doLogInfo = false;
            }
        }
        if (doLogInfo) {
            this.logger.info("{} {}", (Object)msg, (Object)"(future identical logs go to debug)");
        } else {
            this.logger.debug(msg);
        }
    }

    public void infoOrDebug(String msg) {
        this.infoOrDebug(null, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.syncObj;
        synchronized (object) {
            this.lastMsgPerCategory = null;
            this.autoResetTime = this.autoResetDelayMillis == 0L ? Long.MAX_VALUE : System.currentTimeMillis() + this.autoResetDelayMillis;
        }
    }
}

