/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.connectors.announcement;

import org.apache.sling.discovery.base.connectors.BaseConfig;
import org.apache.sling.discovery.base.connectors.announcement.Announcement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedAnnouncement {
    private static final Logger logger = LoggerFactory.getLogger(CachedAnnouncement.class);
    private long lastPing = System.currentTimeMillis();
    private final Announcement announcement;
    private long firstPing = System.currentTimeMillis();
    private long backoffIntervalSeconds = -1L;
    private final BaseConfig config;

    CachedAnnouncement(Announcement announcement, BaseConfig config) {
        this.announcement = announcement;
        this.config = config;
    }

    private long getConfiguredConnectorTimeout() {
        return this.config.getConnectorPingTimeout();
    }

    private long getConfiguredConnectorInterval() {
        return this.config.getConnectorPingInterval();
    }

    public final boolean hasExpired() {
        long now = System.currentTimeMillis();
        long diff = now - this.lastPing;
        return diff >= 1000L * this.getEffectiveHeartbeatTimeout();
    }

    public final long getLastPing() {
        return this.lastPing;
    }

    public final long getFirstPing() {
        return this.firstPing;
    }

    public final long getSecondsUntilTimeout() {
        long now = System.currentTimeMillis();
        long diff = now - this.lastPing;
        long left = 1000L * this.getEffectiveHeartbeatTimeout() - diff;
        return left / 1000L;
    }

    private final long getEffectiveHeartbeatTimeout() {
        long configuredGoodwill = this.getConfiguredConnectorTimeout() - this.getConfiguredConnectorInterval();
        return Math.max(this.getConfiguredConnectorTimeout(), this.backoffIntervalSeconds + configuredGoodwill);
    }

    final long registerPing(Announcement incomingAnnouncement, BaseConfig config) {
        this.lastPing = System.currentTimeMillis();
        this.announcement.registerPing(incomingAnnouncement);
        if (incomingAnnouncement.isInherited()) {
            this.backoffIntervalSeconds = incomingAnnouncement.getBackoffInterval();
            logger.debug("registerPing: inherited announcement - hence returning 0");
            return 0L;
        }
        if (incomingAnnouncement.getResetBackoff()) {
            this.firstPing = this.lastPing;
            logger.debug("registerPing: got a resetBackoff - hence returning 0");
            return 0L;
        }
        long stableSince = this.lastPing - this.firstPing;
        long numStableTimeouts = stableSince / (1000L * config.getConnectorPingTimeout());
        long backoffFactor = Math.min(numStableTimeouts, (long)config.getBackoffStableFactor());
        this.backoffIntervalSeconds = backoffFactor * config.getConnectorPingInterval();
        return this.backoffIntervalSeconds;
    }

    public final Announcement getAnnouncement() {
        return this.announcement;
    }
}

