/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.sling.commons.metrics.internal;

import org.apache.sling.commons.metrics.Meter;

final class MeterImpl implements Meter {
    private final com.codahale.metrics.Meter meter;

    MeterImpl(com.codahale.metrics.Meter meter) {
        this.meter = meter;
    }

    @Override
    public void mark() {
        meter.mark();
    }

    @Override
    public void mark(long n) {
        meter.mark(n);
    }

    @Override
    public long getCount() {
        return meter.getCount();
    }

    @SuppressWarnings("unchecked")
    @Override
    public <A> A adaptTo(Class<A> type) {
        if (type == com.codahale.metrics.Meter.class){
            return (A)meter;
        }
        return null;
    }
}
