/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LogbackServiceProvider;
import org.apache.sling.commons.log.logback.internal.LogConfigManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.LoggerFactoryFriend;
import org.slf4j.spi.SLF4JServiceProvider;

final class SLF4JServiceProviderTracker
extends ServiceTracker<SLF4JServiceProvider, SLF4JServiceProvider> {
    @Nullable
    protected LogConfigManager logConfigManager;

    SLF4JServiceProviderTracker(@NotNull BundleContext bundleContext) {
        super(bundleContext, SLF4JServiceProvider.class, null);
    }

    @NotNull
    public SLF4JServiceProvider addingService(@NotNull ServiceReference<SLF4JServiceProvider> reference) {
        SLF4JServiceProvider service = (SLF4JServiceProvider)super.addingService(reference);
        if (service instanceof LogbackServiceProvider) {
            if (!this.isSlf4jInitialized()) {
                LoggerFactoryFriend.reset();
                ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
                if (iLoggerFactory instanceof LoggerContext) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Slf4j is initialized with the logback impl after the reset");
                } else {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Slf4j is not initialized with the logback impl after the reset");
                }
            }
            if (!this.isSlf4jInitialized()) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Slf4j is not initialized with the logback impl so skipping customization");
            } else {
                this.logConfigManager = new LogConfigManager(this.context);
                this.logConfigManager.start();
            }
        } else {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).debug("addingService is not the LogbackServiceProvider: {}", (Object)service.getClass().getName());
        }
        return service;
    }

    public void removedService(@NotNull ServiceReference<SLF4JServiceProvider> reference, @NotNull SLF4JServiceProvider service) {
        if (service instanceof LogbackServiceProvider) {
            if (this.logConfigManager != null) {
                this.logConfigManager.stop();
                this.logConfigManager = null;
            }
        } else {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).debug("removedService is not the LogbackServiceProvider: {}", (Object)service.getClass().getName());
        }
    }

    private boolean isSlf4jInitialized() {
        return LoggerFactory.getILoggerFactory() instanceof LoggerContext;
    }
}

