/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.resource.impl.def;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.resource.spi.ContextPathStrategy;
import org.apache.sling.caconfig.resource.spi.ContextResource;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ContextPathStrategy.class})
@Designate(ocd=Config.class)
public class DefaultContextPathStrategy
implements ContextPathStrategy {
    private static final Logger log = LoggerFactory.getLogger(DefaultContextPathStrategy.class);
    private volatile Config config;

    @Activate
    private void activate(Config config) {
        this.config = config;
    }

    @NotNull
    public Iterator<ContextResource> findContextResources(@NotNull Resource resource) {
        if (!this.config.enabled()) {
            return Collections.emptyIterator();
        }
        return new ConfigResourceIterator(resource);
    }

    @ObjectClassDefinition(name="Apache Sling Context-Aware Configuration Default Context Path Strategy", description="Detects context path by existence of sling:configRef properties.")
    public static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable this context path strategy.")
        public boolean enabled() default true;

        @AttributeDefinition(name="Config ref. resource names", description="Names of resource to try to look up sling:configRef property in. If list is empty only current resource is checked. If the list is not empty than only those listed resources are used for look up. If you want to include the current resource you can use a dot for the value.")
        public String[] configRefResourceNames();

        @AttributeDefinition(name="Config ref. property names", description="Additional property names to sling:configRef to look up a configuration reference. The names are used in the order defined, always starting with sling:configRef. Once a property with a value is found, that value is used and the following property names are skipped.")
        public String[] configRefPropertyNames();

        @AttributeDefinition(name="Service Ranking", description="Priority of persistence strategy (higher = higher priority).")
        public int service_ranking() default 0;
    }

    private class ConfigResourceIterator
    implements Iterator<ContextResource> {
        private ContextResource next;

        public ConfigResourceIterator(Resource startResource) {
            this.next = this.findNextContextResource(startResource);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public ContextResource next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            ContextResource result = this.next;
            this.next = this.findNextContextResource(this.next.getResource().getParent());
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private ContextResource findNextContextResource(Resource startResource) {
            for (Resource resource = startResource; resource != null; resource = resource.getParent()) {
                String configRef = this.getConfigRef(resource);
                if (configRef == null) continue;
                log.trace("+ Found context path {}, configRef {}", (Object)resource.getPath(), (Object)configRef);
                return new ContextResource(resource, configRef, DefaultContextPathStrategy.this.config.service_ranking());
            }
            return null;
        }

        private String getConfigRefValue(Resource resource) {
            ValueMap map = resource.getValueMap();
            String val = (String)map.get("sling:configRef", String.class);
            if (val == null && !ArrayUtils.isEmpty((Object[])DefaultContextPathStrategy.this.config.configRefPropertyNames())) {
                String name;
                String[] stringArray = DefaultContextPathStrategy.this.config.configRefPropertyNames();
                int n = stringArray.length;
                for (int i = 0; i < n && (val = (String)map.get(name = stringArray[i], String.class)) == null; ++i) {
                }
            }
            return val;
        }

        private String getConfigRef(Resource resource) {
            if (ArrayUtils.isEmpty((Object[])DefaultContextPathStrategy.this.config.configRefResourceNames())) {
                return this.getConfigRefValue(resource);
            }
            for (String name : DefaultContextPathStrategy.this.config.configRefResourceNames()) {
                String configRef;
                Resource lookupResource = resource.getChild(name);
                if (lookupResource == null || (configRef = this.getConfigRefValue(lookupResource)) == null) continue;
                return configRef;
            }
            return null;
        }
    }
}

