/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;

class NameSanitizer
implements Function<String, String> {
    static final NameSanitizer INSTANCE = new NameSanitizer();
    static final Pattern SANITIZE_CONSECUTIVE_UNDERSCORES = Pattern.compile("[_]{2,}");
    private static final Pattern SANITIZE_PREFIX_PATTERN = Pattern.compile("^[^a-zA-Z_:]");
    private static final Pattern SANITIZE_BODY_PATTERN = Pattern.compile("[^a-zA-Z0-9_:]");
    private final Function<String, String> delegate;
    private final Map<String, String> cache = new ConcurrentHashMap<String, String>();

    NameSanitizer() {
        this(NameSanitizer::sanitizeMetricName);
    }

    NameSanitizer(Function<String, String> delegate) {
        this.delegate = delegate;
    }

    @Override
    public String apply(String labelName) {
        return this.cache.computeIfAbsent(labelName, this.delegate);
    }

    private static String sanitizeMetricName(String metricName) {
        return SANITIZE_CONSECUTIVE_UNDERSCORES.matcher(SANITIZE_BODY_PATTERN.matcher(SANITIZE_PREFIX_PATTERN.matcher(metricName).replaceFirst("_")).replaceAll("_")).replaceAll("_");
    }
}

