"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const mocha_1 = require("mocha");
const sinon = __importStar(require("sinon"));
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
const AjaxImpl_1 = require("../../impl/AjaxImpl");
const chai_1 = require("chai");
var protocolPage = StandardInits_1.StandardInits.protocolPage;
const mona_dish_1 = require("mona-dish");
const XmlResponses_1 = require("../frameworkBase/_ext/shared/XmlResponses");
(0, mocha_1.describe)('tests the addOnEvent and addOnError handling', function () {
    // noinspection DuplicatedCode
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = protocolPage();
            return waitForResult.then((close) => {
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                this.respond = (response) => {
                    let xhrReq = this.requests.shift();
                    xhrReq.responsetype = "text/xml";
                    xhrReq.respond(200, { 'Content-Type': 'text/xml' }, response);
                    return xhrReq;
                };
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                global.XMLHttpRequest = this.xhr;
                window.XMLHttpRequest = this.xhr;
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    AjaxImpl_1.Implementation.reset();
                    close();
                };
            });
        });
    });
    afterEach(function () {
        this.closeIt();
    });
    it("must have a global add on event call with all three phases passed", function () {
        let onEventCalled1 = 0;
        let onEventCalled2 = 0;
        faces.ajax.addOnEvent((data) => {
            onEventCalled1++;
            if (onEventCalled1 == 1 && data.status != "begin") {
                throw ("Wrong status");
            }
            if (onEventCalled1 == 2 && data.status != "complete") {
                throw ("Wrong status");
            }
            if (onEventCalled1 == 3 && data.status != "success") {
                throw ("Wrong status");
            }
        });
        faces.ajax.addOnEvent(() => {
            onEventCalled2++;
        });
        mona_dish_1.DQ.byId("cmd_update_insert").click();
        this.respond(XmlResponses_1.XmlResponses.UPDATE_INSERT_1);
        (0, chai_1.expect)(onEventCalled1).to.eq(3);
        (0, chai_1.expect)(onEventCalled2).to.eq(3);
    });
    it("must have onError called in case of error", function () {
        const oldErr = console.error;
        console.error = () => { };
        try {
            let onErrorCalled1 = 0;
            let onErrorCalled2 = 0;
            let errorTitle = '';
            let errorMessage = '';
            faces.ajax.addOnError((data) => {
                errorTitle = data.errorName;
                errorMessage = data.errorMessage;
                onErrorCalled1++;
            });
            faces.ajax.addOnError(() => {
                onErrorCalled2++;
            });
            //cmd_error_component
            mona_dish_1.DQ.byId("cmd_error_component").click();
            this.respond(XmlResponses_1.XmlResponses.ERROR_2);
            (0, chai_1.expect)(onErrorCalled1).to.eq(1);
            (0, chai_1.expect)(onErrorCalled2).to.eq(1);
            (0, chai_1.expect)(errorTitle).to.eq('Erro21');
            (0, chai_1.expect)(errorMessage).to.eq('Error2 Text');
        }
        finally {
            console.error = oldErr;
        }
    });
    it("must have an id set if there is an emitting element", function () {
        let onEventCalled2 = 0;
        let assertSourceExists = (data) => {
            var _a;
            (0, chai_1.expect)(!!((_a = data === null || data === void 0 ? void 0 : data.source) === null || _a === void 0 ? void 0 : _a.id)).to.be.true;
        };
        faces.ajax.addOnEvent((data) => {
            assertSourceExists(data);
        });
        faces.ajax.addOnEvent(() => {
            onEventCalled2++;
        });
        mona_dish_1.DQ.byId("cmd_update_insert").click();
        this.respond(XmlResponses_1.XmlResponses.UPDATE_INSERT_1);
    });
    it("must keep the source despite source being deleted in the dom", function () {
        let onEventCalled2 = 0;
        let assertSourceExists = (data) => {
            var _a;
            (0, chai_1.expect)(!!((_a = data === null || data === void 0 ? void 0 : data.source) === null || _a === void 0 ? void 0 : _a.id)).to.be.true;
        };
        faces.ajax.addOnEvent((data) => {
            assertSourceExists(data);
            if (data.status == "complete") {
                //we now remove the source from the dom to simulate a page change
                mona_dish_1.DQ.byId(data.source).delete();
            }
        });
        faces.ajax.addOnEvent(() => {
            onEventCalled2++;
        });
        mona_dish_1.DQ.byId("cmd_update_insert").click();
        this.respond(XmlResponses_1.XmlResponses.UPDATE_INSERT_1);
    });
});
//# sourceMappingURL=EventTests.spec.js.map