"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
const sinon = __importStar(require("sinon"));
const AjaxImpl_1 = require("../../impl/AjaxImpl");
const chai_1 = require("chai");
var protocolPage = StandardInits_1.StandardInits.protocolPage;
const jsdom = require("jsdom");
const { JSDOM } = jsdom;
describe("Should trigger the progress on xhr request", function () {
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = protocolPage();
            //build up the test fixture
            return waitForResult.then((close) => {
                //we generate an xhr mock class replacement
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                //we store the requests to have access to them later
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                //we anchchor the mock into the fake dom
                global.XMLHttpRequest = this.xhr;
                window.XMLHttpRequest = this.xhr;
                //general cleanup of overloaded resources
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    AjaxImpl_1.Implementation.reset();
                    close();
                };
            });
        });
    });
    afterEach(function () {
        this.closeIt();
    });
    it("must trigger progress on xhr request", function () {
        let caughtProgressEvents = [];
        var preinitTriggered = false;
        var loadstartTriggered = false;
        var loadTriggered = false;
        var loadendTriggered = false;
        var timeoutTriggered = false;
        var abortTriggered = false;
        var errorTriggered = false;
        faces.ajax.request(document.getElementById("cmd_eval"), null, {
            render: '@form',
            execute: '@form',
            myfaces: {
                upload: {
                    progress: (upload, event) => {
                        caughtProgressEvents.push(event);
                    },
                    preinit: (upload) => preinitTriggered = true,
                    loadstart: (upload, event) => loadstartTriggered = true,
                    load: (upload, event) => loadTriggered = true,
                    loadend: (upload, event) => loadendTriggered = true,
                    error: (upload, event) => errorTriggered = true,
                    abort: (upload, event) => abortTriggered = true,
                    timeout: (upload, event) => timeoutTriggered = true,
                }
            }
        });
        let progressEvent = new ProgressEvent("progress");
        let progressEvent2 = new ProgressEvent("progress");
        let xhr = this.requests.shift();
        xhr.upload.dispatchEvent(new ProgressEvent("loadstart"));
        xhr.upload.dispatchEvent(new ProgressEvent("load"));
        xhr.upload.dispatchEvent(progressEvent);
        xhr.upload.dispatchEvent(progressEvent2);
        xhr.upload.dispatchEvent(new ProgressEvent("loadend"));
        xhr.upload.dispatchEvent(new ProgressEvent("error"));
        xhr.upload.dispatchEvent(new ProgressEvent("abort"));
        xhr.upload.dispatchEvent(new ProgressEvent("timeout"));
        (0, chai_1.expect)(caughtProgressEvents.length).to.eq(2);
        (0, chai_1.expect)(caughtProgressEvents[0] === progressEvent).to.eq(true);
        (0, chai_1.expect)(caughtProgressEvents[1] === progressEvent2).to.eq(true);
        (0, chai_1.expect)(preinitTriggered).to.eq(true);
        (0, chai_1.expect)(loadstartTriggered).to.eq(true);
        (0, chai_1.expect)(loadTriggered).to.eq(true);
        (0, chai_1.expect)(loadendTriggered).to.eq(true);
        (0, chai_1.expect)(errorTriggered).to.eq(true);
        (0, chai_1.expect)(abortTriggered).to.eq(true);
        (0, chai_1.expect)(timeoutTriggered).to.eq(true);
    });
});
//# sourceMappingURL=XhrRequestProgress.spec.js.map