export interface MinimatchOptions {
    nobrace?: boolean;
    nocomment?: boolean;
    nonegate?: boolean;
    debug?: boolean;
    noglobstar?: boolean;
    noext?: boolean;
    nonull?: boolean;
    windowsPathsNoEscape?: boolean;
    allowWindowsEscape?: boolean;
    partial?: boolean;
    dot?: boolean;
    nocase?: boolean;
    matchBase?: boolean;
    flipNegate?: boolean;
    preserveMultipleSlashes?: boolean;
}
export declare const minimatch: {
    (p: string, pattern: string, options?: MinimatchOptions): boolean;
    sep: string;
    GLOBSTAR: typeof GLOBSTAR;
    filter: (pattern: string, options?: MinimatchOptions) => (p: string) => boolean;
    defaults: (def: MinimatchOptions) => typeof minimatch;
    braceExpand: (pattern: string, options?: MinimatchOptions) => string[];
    makeRe: (pattern: string, options?: MinimatchOptions) => false | MMRegExp;
    match: (list: string[], pattern: string, options?: MinimatchOptions) => string[];
    Minimatch: typeof Minimatch;
};
export default minimatch;
export declare const sep: string;
export declare const GLOBSTAR: unique symbol;
export declare const filter: (pattern: string, options?: MinimatchOptions) => (p: string) => boolean;
export declare const defaults: (def: MinimatchOptions) => typeof minimatch;
export declare const braceExpand: (pattern: string, options?: MinimatchOptions) => string[];
declare const SUBPARSE: unique symbol;
export declare const makeRe: (pattern: string, options?: MinimatchOptions) => false | MMRegExp;
export declare const match: (list: string[], pattern: string, options?: MinimatchOptions) => string[];
type MMRegExp = RegExp & {
    _src?: string;
    _glob?: string;
};
type SubparseReturn = [string, boolean];
type ParseReturnFiltered = string | MMRegExp | typeof GLOBSTAR;
type ParseReturn = ParseReturnFiltered | false;
export declare class Minimatch {
    options: MinimatchOptions;
    set: ParseReturnFiltered[][];
    pattern: string;
    windowsPathsNoEscape: boolean;
    nonegate: boolean;
    negate: boolean;
    comment: boolean;
    empty: boolean;
    preserveMultipleSlashes: boolean;
    partial: boolean;
    globSet: string[];
    globParts: string[][];
    regexp: false | null | MMRegExp;
    constructor(pattern: string, options?: MinimatchOptions);
    debug(..._: any[]): void;
    make(): void;
    parseNegate(): void;
    matchOne(file: string[], pattern: ParseReturn[], partial?: boolean): boolean;
    braceExpand(): string[];
    parse(pattern: string, isSub?: typeof SUBPARSE): ParseReturn | SubparseReturn;
    makeRe(): false | MMRegExp;
    slashSplit(p: string): string[];
    match(f: string, partial?: boolean): boolean;
    static defaults(def: MinimatchOptions): typeof Minimatch;
}
