/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package javax.faces.event;

import javax.faces.component.UIComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.context.FacesContext;

/**
 * @since 2.0
 */
public class AjaxBehaviorEvent extends BehaviorEvent
{

    public AjaxBehaviorEvent(FacesContext facesContext, UIComponent uiComponent, Behavior behavior)
    {
        super(facesContext, uiComponent, behavior);
    }

    /**
     * @param component
     * @param behavior
     */
    public AjaxBehaviorEvent(UIComponent component, Behavior behavior)
    {
        super(component, behavior);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isAppropriateListener(FacesListener faceslistener)
    {
        return faceslistener instanceof AjaxBehaviorListener;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void processListener(FacesListener faceslistener)
    {
        ((AjaxBehaviorListener)faceslistener).processAjaxBehavior(this);
    }

}
