/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.nio.file.Path;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.composite.MergeStrategy;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.PasswordDecryptor;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.kit.env.Log4jProperty;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.util.StringMap;
import org.jspecify.annotations.Nullable;

public final class CoreProperties {
    private CoreProperties() {
    }

    @Log4jProperty(name="v1")
    public record Version1Properties(boolean compatibility, @Nullable String configuration, int monitorInterval) {
    }

    @Log4jProperty(name="uuid")
    public record UuidProperties(long sequence) {
    }

    @Log4jProperty(name="transportSecurity")
    public record TransportSecurityProperties(KeyStoreProperties trustStore, KeyStoreProperties keyStore, boolean verifyHostName) {
        public static TransportSecurityProperties defaultValue() {
            return new TransportSecurityProperties(KeyStoreProperties.defaultValue(), KeyStoreProperties.defaultValue(), false);
        }

        public TransportSecurityProperties withKeyStore(KeyStoreProperties keyStore) {
            return new TransportSecurityProperties(this.trustStore, keyStore, this.verifyHostName);
        }

        public TransportSecurityProperties withTrustStore(KeyStoreProperties trustStore) {
            return new TransportSecurityProperties(trustStore, this.keyStore, this.verifyHostName);
        }
    }

    public record ThreadContextMapProperties(@Log4jProperty(defaultValue="true") boolean enable, boolean garbageFree, @Log4jProperty(defaultValue="16") int initialCapacity, @Nullable String type) {
    }

    @Log4jProperty(name="threadContext")
    public record ThreadContextProperties(@Log4jProperty(defaultValue="true") boolean enable, @Log4jProperty(defaultValue="true") boolean enableStack, ThreadContextMapProperties map) {
    }

    @Log4jProperty(name="statusLogger")
    public record StatusLoggerProperties(@Log4jProperty(defaultValue="ERROR") Level level) {
    }

    @Log4jProperty(name="message")
    public record MessageProperties(@Nullable Class<? extends MessageFactory> factory) {
    }

    @Log4jProperty(name="loggerContext")
    public record LoggerContextProperties(@Nullable Class<? extends LoggerContextFactory> factory, @Nullable Class<? extends ContextSelector> selector, @Nullable Class<? extends ShutdownCallbackRegistry> shutdownCallbackRegistry, @Nullable Boolean shutdownHookEnabled, boolean stacktraceOnStart) {
    }

    public record ContextDataProperties(@Nullable Class<? extends StringMap> type, @Nullable Class<? extends ContextDataInjector> injector) {
    }

    @Log4jProperty(name="logEvent")
    public record LogEventProperties(ContextDataProperties contextData, @Nullable Class<? extends LogEventFactory> factory) {
    }

    @Log4jProperty(name="loader")
    public record LoaderProperties(boolean ignoreTccl) {
    }

    public record KeyStoreProperties(KeyManagerFactoryProperties keyManagerFactory, @Nullable String location, char @Nullable [] password, @Nullable String passwordEnvVar, @Nullable Path passwordFile, @Nullable String type) {
        public static KeyStoreProperties defaultValue() {
            return new KeyStoreProperties(null, null, null, null, null, null);
        }
    }

    public record KeyManagerFactoryProperties(@Nullable String algorithm) {
    }

    @Log4jProperty(name="gc")
    public record GarbageCollectionProperties(@Log4jProperty(defaultValue="8192") int encoderByteBufferSize, @Log4jProperty(defaultValue="2048") int encoderCharBufferSize, @Log4jProperty(defaultValue="true") boolean enableDirectEncoders, @Log4jProperty(defaultValue="128") int initialReusableMessageSize, @Log4jProperty(defaultValue="518") int maxReusableMessageSize, @Log4jProperty(defaultValue="2048") int layoutStringBuilderMaxSize) {
    }

    @Log4jProperty(name="configuration")
    public record ConfigurationProperties(@Log4jProperty(defaultValue="file,https,jar") String allowedProtocols, @Nullable String clock, @Nullable Class<? extends ConfigurationFactory> factory, @Log4jProperty(defaultValue="ERROR") Level level, @Nullable String location, @Nullable Class<? extends MergeStrategy> mergeStrategy, @Log4jProperty(defaultValue="AwaitCompletion") String reliabilityStrategy, boolean usePreciseClock, @Log4jProperty(defaultValue="5000") long waitMillisBeforeStopOldConfig) {
    }

    public record BasicAuthenticationProperties(String username, String password, Class<? extends PasswordDecryptor> passwordDecryptor) {
    }

    @Log4jProperty(name="auth")
    public record AuthenticationProperties(@Nullable Class<? extends AuthorizationProvider> provider, BasicAuthenticationProperties basic) {
    }

    @Log4jProperty(name="async.queueFullPolicy")
    public record QueueFullPolicyProperties(@Nullable String type, @Log4jProperty(defaultValue="INFO") Level discardThreshold) {
        public static QueueFullPolicyProperties defaultValue() {
            return new QueueFullPolicyProperties(null, Level.INFO);
        }

        public QueueFullPolicyProperties withType(@Nullable String type) {
            return new QueueFullPolicyProperties(type, this.discardThreshold);
        }

        public QueueFullPolicyProperties withLevel(Level discardThreshold) {
            return new QueueFullPolicyProperties(this.type, discardThreshold);
        }
    }

    @Log4jProperty(name="async")
    public record AsyncProperties(boolean formatMessagesInBackground) {
    }
}

