/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.arbiters;

import org.apache.logging.log4j.core.config.arbiters.Arbiter;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Factory;
import org.apache.logging.log4j.plugins.Plugin;

@Configurable(elementType="Arbiter", printObject=true, deferChildren=true)
@Plugin
public class EnvironmentArbiter
implements Arbiter {
    private final String propertyName;
    private final String propertyValue;

    private EnvironmentArbiter(String propertyName, String propertyValue) {
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
    }

    @Override
    public boolean isCondition() {
        String value = System.getenv(this.propertyName);
        return value != null && (this.propertyValue == null || value.equals(this.propertyValue));
    }

    @Factory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<EnvironmentArbiter> {
        public static final String ATTR_PROPERTY_NAME = "propertyName";
        public static final String ATTR_PROPERTY_VALUE = "propertyValue";
        @PluginBuilderAttribute(value="propertyName")
        private String propertyName;
        @PluginBuilderAttribute(value="propertyValue")
        private String propertyValue;

        public Builder setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this.asBuilder();
        }

        public Builder setPropertyValue(String propertyValue) {
            this.propertyValue = propertyValue;
            return this.asBuilder();
        }

        public Builder asBuilder() {
            return this;
        }

        @Override
        public EnvironmentArbiter build() {
            return new EnvironmentArbiter(this.propertyName, this.propertyValue);
        }
    }
}

