/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kit.recycler.internal;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.kit.recycler.Recycler;
import org.apache.logging.log4j.kit.recycler.RecyclerFactory;
import org.apache.logging.log4j.kit.recycler.RecyclerFactoryProvider;
import org.apache.logging.log4j.kit.recycler.RecyclerProperties;
import org.apache.logging.log4j.kit.recycler.support.AbstractRecycler;

@ServiceProvider(value=RecyclerFactoryProvider.class)
public final class QueueingRecyclerFactoryProvider
implements RecyclerFactoryProvider {
    @Override
    public int getOrder() {
        return 800;
    }

    @Override
    public String getName() {
        return "queue";
    }

    @Override
    public RecyclerFactory createForEnvironment(PropertyEnvironment environment) {
        Objects.requireNonNull(environment, "environment");
        int capacity = environment.getProperty(RecyclerProperties.class).capacity();
        return new QueueingRecyclerFactory(capacity);
    }

    static final class QueueingRecyclerFactory
    implements RecyclerFactory {
        final int capacity;

        private QueueingRecyclerFactory(int capacity) {
            this.capacity = capacity;
        }

        @Override
        public <V> Recycler<V> create(Supplier<V> supplier, Consumer<V> cleaner) {
            Objects.requireNonNull(supplier, "supplier");
            Objects.requireNonNull(cleaner, "cleaner");
            ArrayBlockingQueue queue = new ArrayBlockingQueue(this.capacity);
            return new QueueingRecycler<V>(supplier, cleaner, queue);
        }

        static final class QueueingRecycler<V>
        extends AbstractRecycler<V> {
            private final Consumer<V> cleaner;
            final Queue<V> queue;

            private QueueingRecycler(Supplier<V> supplier, Consumer<V> cleaner, Queue<V> queue) {
                super(supplier);
                this.cleaner = cleaner;
                this.queue = queue;
            }

            @Override
            public V acquire() {
                V value = this.queue.poll();
                return value != null ? value : this.createInstance();
            }

            @Override
            public void release(V value) {
                Objects.requireNonNull(value, "value");
                this.cleaner.accept(value);
                this.queue.offer(value);
            }
        }
    }
}

