/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kit.env.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PropertyMapping {
    public static final PropertyMapping EMPTY = new PropertyMapping(Stream.empty());
    private final Map<String, List<String>> mapping;

    PropertyMapping(Stream<Map.Entry<String, List<String>>> entries) {
        this.mapping = entries.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (c1, c2) -> {
            ArrayList result = new ArrayList(c1.size() + c2.size());
            result.addAll(c1);
            result.addAll(c2);
            return result;
        }));
    }

    List<? extends String> getLegacyKeys(String key) {
        return this.mapping.getOrDefault(key, Collections.emptyList());
    }

    PropertyMapping merge(PropertyMapping other) {
        return new PropertyMapping(Stream.concat(this.mapping.entrySet().stream(), other.mapping.entrySet().stream()));
    }
}

