/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.constant;

import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.IllegalCompactionPerformerException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadPointCompactionPerformer;

public enum CrossCompactionPerformer {
    READ_POINT,
    FAST;


    public static CrossCompactionPerformer getCrossCompactionPerformer(String name) {
        if (READ_POINT.toString().equalsIgnoreCase(name)) {
            return READ_POINT;
        }
        if (FAST.toString().equalsIgnoreCase(name)) {
            return FAST;
        }
        throw new IllegalCompactionPerformerException("Illegal compaction performer for cross compaction " + name);
    }

    public ICrossCompactionPerformer createInstance() {
        switch (this) {
            case READ_POINT: {
                return new ReadPointCompactionPerformer();
            }
            case FAST: {
                return new FastCompactionPerformer(true);
            }
        }
        throw new IllegalCompactionPerformerException("Illegal compaction performer for cross compaction " + (Object)((Object)this));
    }
}

