/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.column.LongColumn;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.read.common.block.column.TimeColumn;

public class LongConstantFill
implements IFill {
    private final long value;
    private final long[] valueArray;

    public LongConstantFill(long value) {
        this.value = value;
        this.valueArray = new long[]{value};
    }

    @Override
    public Column fill(TimeColumn timeColumn, Column valueColumn) {
        int size = valueColumn.getPositionCount();
        if (!valueColumn.mayHaveNull() || size == 0) {
            return valueColumn;
        }
        if (valueColumn instanceof RunLengthEncodedColumn) {
            return new RunLengthEncodedColumn((Column)new LongColumn(1, Optional.empty(), this.valueArray), size);
        }
        long[] array = new long[size];
        for (int i = 0; i < size; ++i) {
            array[i] = valueColumn.isNull(i) ? this.value : valueColumn.getLong(i);
        }
        return new LongColumn(size, Optional.empty(), array);
    }
}

