/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.ToLongFunction;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.IMetric;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.tsfile.utils.Pair;

public abstract class AbstractMetricManager {
    protected static final MetricConfig METRIC_CONFIG = MetricConfigDescriptor.getInstance().getMetricConfig();
    protected static boolean isEnableMetric;
    protected Map<String, MetricInfo.MetaInfo> nameToMetaInfo;
    protected Map<MetricInfo, IMetric> metrics;

    public AbstractMetricManager() {
        isEnableMetric = METRIC_CONFIG.getEnableMetric();
        this.nameToMetaInfo = new ConcurrentHashMap<String, MetricInfo.MetaInfo>();
        this.metrics = new ConcurrentHashMap<MetricInfo, IMetric>();
    }

    public Counter getOrCreateCounter(String name, MetricLevel metricLevel, String ... tags) {
        if (!this.isValid(metricLevel, name, tags)) {
            return DoNothingMetricManager.doNothingCounter;
        }
        MetricInfo metricInfo = new MetricInfo(MetricType.COUNTER, name, tags);
        IMetric metric = this.metrics.computeIfAbsent(metricInfo, key -> {
            Counter counter = this.createCounter(metricInfo);
            this.nameToMetaInfo.put(name, metricInfo.getMetaInfo());
            return counter;
        });
        if (metric instanceof Counter) {
            return (Counter)metric;
        }
        throw new IllegalArgumentException(metricInfo + " is already used for a different type of name");
    }

    protected abstract Counter createCounter(MetricInfo var1);

    public <T> Gauge getOrCreateAutoGauge(String name, MetricLevel metricLevel, T obj, ToLongFunction<T> mapper, String ... tags) {
        if (!this.isValid(metricLevel, name, tags)) {
            return DoNothingMetricManager.doNothingGauge;
        }
        MetricInfo metricInfo = new MetricInfo(MetricType.GAUGE, name, tags);
        IMetric metric = this.metrics.computeIfAbsent(metricInfo, key -> {
            Gauge gauge = this.createAutoGauge(metricInfo, obj, mapper);
            this.nameToMetaInfo.put(name, metricInfo.getMetaInfo());
            return gauge;
        });
        if (metric instanceof Gauge) {
            return (Gauge)metric;
        }
        throw new IllegalArgumentException(metricInfo + " is already used for a different type of name");
    }

    protected abstract <T> Gauge createAutoGauge(MetricInfo var1, T var2, ToLongFunction<T> var3);

    public Gauge getOrCreateGauge(String name, MetricLevel metricLevel, String ... tags) {
        if (!this.isValid(metricLevel, name, tags)) {
            return DoNothingMetricManager.doNothingGauge;
        }
        MetricInfo metricInfo = new MetricInfo(MetricType.GAUGE, name, tags);
        IMetric metric = this.metrics.computeIfAbsent(metricInfo, key -> {
            Gauge gauge = this.createGauge(metricInfo);
            this.nameToMetaInfo.put(name, metricInfo.getMetaInfo());
            return gauge;
        });
        if (metric instanceof Gauge) {
            return (Gauge)metric;
        }
        throw new IllegalArgumentException(metricInfo + " is already used for a different type of name");
    }

    protected abstract Gauge createGauge(MetricInfo var1);

    public Rate getOrCreateRate(String name, MetricLevel metricLevel, String ... tags) {
        if (!this.isValid(metricLevel, name, tags)) {
            return DoNothingMetricManager.doNothingRate;
        }
        MetricInfo metricInfo = new MetricInfo(MetricType.RATE, name, tags);
        IMetric metric = this.metrics.computeIfAbsent(metricInfo, key -> {
            Rate rate = this.createRate(metricInfo);
            this.nameToMetaInfo.put(name, metricInfo.getMetaInfo());
            return rate;
        });
        if (metric instanceof Rate) {
            return (Rate)metric;
        }
        throw new IllegalArgumentException(metricInfo + " is already used for a different type of name");
    }

    protected abstract Rate createRate(MetricInfo var1);

    public Histogram getOrCreateHistogram(String name, MetricLevel metricLevel, String ... tags) {
        if (!this.isValid(metricLevel, name, tags)) {
            return DoNothingMetricManager.doNothingHistogram;
        }
        MetricInfo metricInfo = new MetricInfo(MetricType.HISTOGRAM, name, tags);
        IMetric metric = this.metrics.computeIfAbsent(metricInfo, key -> {
            Histogram histogram = this.createHistogram(metricInfo);
            this.nameToMetaInfo.put(name, metricInfo.getMetaInfo());
            return histogram;
        });
        if (metric instanceof Histogram) {
            return (Histogram)metric;
        }
        throw new IllegalArgumentException(metricInfo + " is already used for a different type of name");
    }

    protected abstract Histogram createHistogram(MetricInfo var1);

    public Timer getOrCreateTimer(String name, MetricLevel metricLevel, String ... tags) {
        if (!this.isValid(metricLevel, name, tags)) {
            return DoNothingMetricManager.doNothingTimer;
        }
        MetricInfo metricInfo = new MetricInfo(MetricType.TIMER, name, tags);
        IMetric metric = this.metrics.computeIfAbsent(metricInfo, key -> {
            Timer timer = this.createTimer(metricInfo);
            this.nameToMetaInfo.put(name, metricInfo.getMetaInfo());
            return timer;
        });
        if (metric instanceof Timer) {
            return (Timer)metric;
        }
        throw new IllegalArgumentException(metricInfo + " is already used for a different type of name");
    }

    protected abstract Timer createTimer(MetricInfo var1);

    public Counter count(long delta, String name, MetricLevel metricLevel, String ... tags) {
        Counter counter = this.getOrCreateCounter(name, metricLevel, tags);
        counter.inc(delta);
        return counter;
    }

    public Gauge gauge(long value, String name, MetricLevel metricLevel, String ... tags) {
        Gauge gauge = this.getOrCreateGauge(name, metricLevel, tags);
        gauge.set(value);
        return gauge;
    }

    public Rate rate(long value, String name, MetricLevel metricLevel, String ... tags) {
        Rate rate = this.getOrCreateRate(name, metricLevel, tags);
        rate.mark(value);
        return rate;
    }

    public Histogram histogram(long value, String name, MetricLevel metricLevel, String ... tags) {
        Histogram histogram = this.getOrCreateHistogram(name, metricLevel, tags);
        histogram.update(value);
        return histogram;
    }

    public Timer timer(long delta, TimeUnit timeUnit, String name, MetricLevel metricLevel, String ... tags) {
        Timer timer = this.getOrCreateTimer(name, metricLevel, tags);
        timer.update(delta, timeUnit);
        return timer;
    }

    protected List<Pair<String, String[]>> getAllMetricKeys() {
        ArrayList<Pair<String, String[]>> keys = new ArrayList<Pair<String, String[]>>(this.metrics.size());
        this.metrics.keySet().forEach(k -> keys.add(k.toStringArray()));
        return keys;
    }

    public Map<MetricInfo, IMetric> getMetricsByType(MetricType metricType) {
        HashMap<MetricInfo, IMetric> metricInfoIMetricMap = new HashMap<MetricInfo, IMetric>();
        for (Map.Entry<MetricInfo, IMetric> entry : this.metrics.entrySet()) {
            if (entry.getKey().getMetaInfo().getType() != metricType) continue;
            metricInfoIMetricMap.put(entry.getKey(), entry.getValue());
        }
        return metricInfoIMetricMap;
    }

    public void remove(MetricType type, String name, String ... tags) {
        MetricInfo metricInfo;
        if (this.isEnableMetric() && this.metrics.containsKey(metricInfo = new MetricInfo(type, name, tags))) {
            if (type == metricInfo.getMetaInfo().getType()) {
                this.nameToMetaInfo.remove(metricInfo.getName());
                this.metrics.remove(metricInfo);
                this.removeMetric(type, metricInfo);
            } else {
                throw new IllegalArgumentException(metricInfo + " failed to remove because the mismatch of type. ");
            }
        }
    }

    protected abstract void removeMetric(MetricType var1, MetricInfo var2);

    public boolean isEnableMetric() {
        return isEnableMetric;
    }

    public boolean isEnableMetricInGivenLevel(MetricLevel metricLevel) {
        return this.isEnableMetric() && MetricLevel.higherOrEqual(metricLevel, METRIC_CONFIG.getMetricLevel());
    }

    protected boolean stop() {
        isEnableMetric = METRIC_CONFIG.getEnableMetric();
        this.metrics = new ConcurrentHashMap<MetricInfo, IMetric>();
        this.nameToMetaInfo = new ConcurrentHashMap<String, MetricInfo.MetaInfo>();
        return this.stopFramework();
    }

    protected abstract boolean stopFramework();

    private boolean isValid(MetricLevel metricLevel, String name, String ... tags) {
        if (!this.isEnableMetricInGivenLevel(metricLevel)) {
            return false;
        }
        if (!this.nameToMetaInfo.containsKey(name)) {
            return true;
        }
        MetricInfo.MetaInfo metaInfo = this.nameToMetaInfo.get(name);
        return metaInfo.hasSameKey(tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMetricManager that = (AbstractMetricManager)o;
        return Objects.equals(this.metrics, that.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.metrics);
    }
}

