/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.function.Predicate;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.utils.ValueIterator;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.BooleanStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.IntegerStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SumAggrResult
extends AggregateResult {
    private TSDataType seriesDataType;

    public SumAggrResult(TSDataType seriesDataType) {
        super(TSDataType.DOUBLE, AggregationType.SUM);
        this.seriesDataType = seriesDataType;
        this.reset();
    }

    @Override
    public Double getResult() {
        return this.hasCandidateResult() ? Double.valueOf(this.getDoubleValue()) : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        if (statistics != null && statistics.getCount() > 0L) {
            double preValue = this.getDoubleValue();
            preValue = statistics instanceof IntegerStatistics || statistics instanceof BooleanStatistics ? (preValue += (double)statistics.getSumLongValue()) : (preValue += statistics.getSumDoubleValue());
            this.setDoubleValue(preValue);
        }
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator) {
        this.updateResultFromPageData(batchIterator, time -> false);
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator, Predicate<Long> boundPredicate) {
        while (batchIterator.hasNext(boundPredicate) && !boundPredicate.test(batchIterator.currentTime())) {
            this.updateSum(batchIterator.currentValue());
            batchIterator.next();
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        Object[] values = dataReader.getValuesInTimestamps(timestamps, length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            this.updateSum(values[i]);
        }
    }

    @Override
    public void updateResultUsingValues(long[] timestamps, int length, ValueIterator valueIterator) {
        while (valueIterator.hasNext()) {
            this.updateSum(valueIterator.next());
        }
    }

    private void updateSum(Object sumVal) throws UnSupportedDataTypeException {
        if (sumVal != null) {
            double preValue = this.getDoubleValue();
            switch (this.seriesDataType) {
                case INT32: {
                    preValue += (double)((Integer)sumVal).intValue();
                    break;
                }
                case INT64: {
                    preValue += (double)((Long)sumVal).longValue();
                    break;
                }
                case FLOAT: {
                    preValue += (double)((Float)sumVal).floatValue();
                    break;
                }
                case DOUBLE: {
                    preValue += ((Double)sumVal).doubleValue();
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation SUM : %s", this.seriesDataType));
                }
            }
            this.setDoubleValue(preValue);
        }
    }

    public boolean isNotNull() {
        return this.hasCandidateResult;
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void merge(AggregateResult another) {
        if (another instanceof SumAggrResult && ((SumAggrResult)another).isNotNull()) {
            SumAggrResult anotherSum = (SumAggrResult)another;
            double preValue = this.getDoubleValue();
            this.setDoubleValue(preValue + anotherSum.getDoubleValue());
        }
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
        this.seriesDataType = TSDataType.deserialize((byte)buffer.get());
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((TSDataType)this.seriesDataType, (OutputStream)outputStream);
    }
}

