/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.ReloadLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class MetricConfigDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(MetricConfigDescriptor.class);
    private final MetricConfig metricConfig = this.loadProps();

    private MetricConfigDescriptor() {
    }

    public MetricConfig loadProps() {
        MetricConfig metricConfig;
        String url = this.getPropsUrl();
        Constructor constructor = new Constructor(MetricConfig.class);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        if (url != null) {
            try (FileInputStream inputStream = new FileInputStream(url);){
                logger.info("Start to read config file {}", (Object)url);
                metricConfig = (MetricConfig)yaml.load((InputStream)inputStream);
            }
            catch (IOException e) {
                logger.warn("Fail to find config file : {} because of {}, use default config.", (Object)url, (Object)e.getMessage());
                metricConfig = new MetricConfig();
            }
        } else {
            logger.warn("Fail to find config file, use default config.");
            metricConfig = new MetricConfig();
        }
        return metricConfig;
    }

    public ReloadLevel loadHotProps() {
        MetricConfig newMetricConfig = this.loadProps();
        ReloadLevel reloadLevel = ReloadLevel.NOTHING;
        if (newMetricConfig != null && !this.metricConfig.equals(newMetricConfig)) {
            if (!this.metricConfig.getEnableMetric().equals(newMetricConfig.getEnableMetric())) {
                reloadLevel = newMetricConfig.getEnableMetric() != false ? ReloadLevel.START_METRIC : ReloadLevel.STOP_METRIC;
            } else if (this.metricConfig.getEnableMetric().booleanValue()) {
                reloadLevel = !this.metricConfig.getMonitorType().equals((Object)newMetricConfig.getMonitorType()) || !this.metricConfig.getMetricLevel().equals((Object)newMetricConfig.getMetricLevel()) || !this.metricConfig.getPredefinedMetrics().equals(newMetricConfig.getPredefinedMetrics()) || !this.metricConfig.getAsyncCollectPeriodInSecond().equals(newMetricConfig.getAsyncCollectPeriodInSecond()) ? ReloadLevel.RESTART_METRIC : ReloadLevel.RESTART_REPORTER;
            }
            this.metricConfig.copy(newMetricConfig);
        }
        return reloadLevel;
    }

    private String getPropsUrl() {
        String url = System.getProperty("IOTDB_CONF", null);
        if (url == null && (url = System.getProperty("IOTDB_HOME", null)) != null) {
            url = url + File.separator + "conf";
        }
        if (url == null) {
            logger.warn("Cannot find IOTDB_CONF environment variable when loading config file {}, use default configuration", (Object)"iotdb-metric.yml");
            return null;
        }
        url = url + File.separatorChar + "iotdb-metric.yml";
        return url;
    }

    public static MetricConfigDescriptor getInstance() {
        return MetricConfigDescriptorHolder.INSTANCE;
    }

    public MetricConfig getMetricConfig() {
        return this.metricConfig;
    }

    private static class MetricConfigDescriptorHolder {
        private static final MetricConfigDescriptor INSTANCE = new MetricConfigDescriptor();

        private MetricConfigDescriptorHolder() {
        }
    }
}

