/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client.sync;

import java.net.SocketException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.cluster.client.BaseFactory;
import org.apache.iotdb.cluster.client.ClientCategory;
import org.apache.iotdb.cluster.client.IClientManager;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.TSDataService;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.iotdb.rpc.TimeoutChangeableTransport;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class SyncDataClient
extends TSDataService.Client {
    private Node node;
    private ClientCategory category;
    private IClientManager clientManager;

    public SyncDataClient(TProtocol prot) {
        super(prot);
    }

    public SyncDataClient(TProtocolFactory protocolFactory, Node node, ClientCategory category) throws TTransportException {
        super(protocolFactory.getProtocol(RpcTransportFactory.INSTANCE.getTransport((TTransport)new TSocket(TConfigurationConst.defaultTConfiguration, node.getInternalIp(), ClientUtils.getPort(node, category), ClusterConstant.getConnectionTimeoutInMS()))));
        this.node = node;
        this.category = category;
        this.getInputProtocol().getTransport().open();
    }

    public SyncDataClient(TProtocolFactory protocolFactory, Node node, ClientCategory category, IClientManager manager) throws TTransportException {
        this(protocolFactory, node, category);
        this.clientManager = manager;
    }

    public void returnSelf() {
        if (this.clientManager != null) {
            this.clientManager.returnSyncClient((RaftService.Client)this, this.node, this.category);
        }
    }

    public void setTimeout(int timeout) {
        ((TimeoutChangeableTransport)this.getInputProtocol().getTransport()).setTimeout(timeout);
    }

    public void close() {
        this.getInputProtocol().getTransport().close();
    }

    public int getTimeout() throws SocketException {
        return ((TimeoutChangeableTransport)this.getInputProtocol().getTransport()).getTimeOut();
    }

    public String toString() {
        return "Sync" + this.category.getName() + "{node=" + this.node + ",port=" + ClientUtils.getPort(this.node, this.category) + '}';
    }

    public Node getNode() {
        return this.node;
    }

    public static class SyncDataClientFactory
    extends BaseFactory<Node, SyncDataClient> {
        public SyncDataClientFactory(TProtocolFactory protocolFactory, ClientCategory category) {
            super(protocolFactory, category);
        }

        public SyncDataClientFactory(TProtocolFactory protocolFactory, ClientCategory category, IClientManager clientManager) {
            super(protocolFactory, category, clientManager);
        }

        @Override
        public void activateObject(Node node, PooledObject<SyncDataClient> pooledObject) {
            ((SyncDataClient)((Object)pooledObject.getObject())).setTimeout(ClusterConstant.getConnectionTimeoutInMS());
        }

        public void destroyObject(Node node, PooledObject<SyncDataClient> pooledObject) {
            ((SyncDataClient)((Object)pooledObject.getObject())).close();
        }

        public PooledObject<SyncDataClient> makeObject(Node node) throws Exception {
            return new DefaultPooledObject((Object)new SyncDataClient(this.protocolFactory, node, this.category, this.clientPoolManager));
        }

        public boolean validateObject(Node node, PooledObject<SyncDataClient> pooledObject) {
            return pooledObject.getObject() != null && ((SyncDataClient)((Object)pooledObject.getObject())).getInputProtocol().getTransport().isOpen();
        }
    }
}

